<?php

namespace App\Http\Controllers\Customer;

use App\Models\Discount;
use App\Models\Role;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use DataTables;
use Illuminate\Support\Str;

class DiscountController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {

        can('discount.view',true);
        if ($request->ajax()) {
            $data = Discount::select('*');
            if(get_user_role()==2){
                $data->whereHas('created_by_user',function ($query){
                    return $query->where('branch_id',Auth::user()->branch_id);
                });
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('type', function($row){
                    return ucfirst($row->type);
                })
                ->addColumn('created_by', function($row){
                    return (!empty($row->created_by_user)) ? $row->created_by_user->first_name.' '.$row->created_by_user->last_name:'';
                })
                ->addColumn('amount', function($row){
                    return ($row->type=="fixed") ? get_currency().$row->amount:$row->amount.'%';
                })
                ->addColumn('action', function($row){
                    $btn = "";
                    if(can('discount.edit')){
                        $btn.='<a href="" class="btn btn-primary btn-xs edit-discount" data-id="'.$row->id.'" data-target="#editModal" data-toggle="modal">
                                    <i class="fa fa-edit"></i>
                                </a>';
                    }
                    if(can('discount.delete')){
                        $btn.='<a href="'.set_route('discount.delete',['id'=>$row->id]).'" class="btn btn-danger btn-xs delete-row">
                                    <i class="fa fa-close"></i>
                                </a>';
                    }
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
        $roles = Role::all();
        return view('discount.index',compact('roles'));
    }
    //create
    public function create(Request $request)
    {
        can('discount.create',true);
        $roles = Role::all();
        return view('discount.create',compact('roles'));
    }
    public function store(Request $request){
        can('discount.create',true);
        $message_result = [];
        $validator = Validator::make($request->all(), [
            'type' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }else{
            $data = $request->all();
            $data['code'] =  $code = Str::random(10);
            if($data['using_type']=="single"){
                $data['benefit_numbers'] = 1;
            }
            Discount::create($data);
            set_message('Discount was saved successfully.');
        }
        return response()->json(['success'=>true,'message'=>'Discount was saved successfully.']);
    }
    //update
    public function edit(Request $request){
        $row = Discount::find($request->get('id'));
        return response()->json(['success'=>true,'row'=>$row]);
    }
    public function update(Request $request){
        can('discount.edit',true);
        $data = $request->all();
        if(isset($data['_token'])){
            unset($data['_token']);
        }
        if($data['using_type']=="single"){
            $data['benefit_numbers'] = 1;
        }
        Discount::where('id',$request->get('id'))->update($data);
        return response()->json(['success'=>true,'message'=>'Discount was saved successfully.']);
    }
    //delete
    public function destroy(Request $request){
        can('discount.delete',true);
        $row = Discount::findOrFail($request->route('id'));
        $row->delete();
        set_message('Discount was delete successfully.');
        return redirect()->back();
    }
}
