<?php

namespace App\Http\Controllers\Customer;

use App\Models\MemberShip;
use App\Models\Role;
use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use DataTables;

class MemberShipController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {

        can('membership.view',true);
        if ($request->ajax()) {
            $data = MemberShip::select('*');
            if(get_user_role()==2){
                $data->whereHas('created_by_user',function ($query){
                    return $query->where('branch_id',Auth::user()->branch_id);
                });
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->editColumn('user_id', function($row){
                    $template = "";
                    if(!empty($row->user)) {
                        $template = $row->user->first_name . ' ' . $row->user->last_name;
                    }
                   return $template;
                })
                ->addColumn('created_by', function($row){
                    return (!empty($row->created_by_user)) ? $row->created_by_user->first_name.' '.$row->created_by_user->last_name:'';
                })
                ->addColumn('phone', function($row){
                    return (!empty($row->user)) ? $row->user->phone:'';
                })
                ->addColumn('country_code', function($row){
                    return (!empty($row->user)) ? $row->user->country_code:'';
                })
                ->addColumn('percent', function($row){
                   return $row->percent."%";
                })
                ->addColumn('action', function($row){
                    $btn = "";
                    if(can('membership.edit')){
                        $btn.='<a href="" class="btn btn-primary btn-xs edit-membership" data-id="'.$row->id.'" data-target="#editModal" data-toggle="modal">
                                    <i class="fa fa-edit"></i>
                                </a>';
                    }
                    if(can('membership.delete')){
                        $btn.='<a href="'.set_route('membership.delete',['id'=>$row->id]).'" class="btn btn-danger btn-xs delete-row">
                                    <i class="fa fa-close"></i>
                                </a>';
                    }
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
        $users = User::where('role_id',3)->get();
        return view('membership.index',compact('users'));
    }
    //create
    public function create(Request $request)
    {
        can('membership.create',true);
        $roles = Role::all();
        return view('membership.create',compact('roles'));
    }
    public function store(Request $request){
        can('membership.create',true);
        $message_result = [];
        $validator = Validator::make($request->all(), [
            'membership_no' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }else{
            MemberShip::create($request->all());
            set_message('Member ship was saved successfully.');
        }
        return response()->json(['success'=>true,'message'=>'User was created successfully.']);
    }
    //update
    public function edit(Request $request){
        $row = MemberShip::find($request->get('id'));
        return response()->json(['success'=>true,'row'=>$row]);
    }
    public function update($id,Request $request){
        can('shift.edit',true);
        $data = $request->all();
        if(isset($data['_token'])){
            unset($data['_token']);
        }
        MemberShip::where('id',$request->get('id'))->update($data);
        return response()->json(['success'=>true,'message'=>'Member Ship was saved successfully.']);
    }
    //delete
    public function destroy($id,Request $request){
        can('shift.delete',true);
        $row = MemberShip::findOrFail($request->route('id'));
        $row->delete();
        set_message('Member Ship was delete successfully.');
        return redirect()->back();
    }
}
