<?php

namespace App\Http\Controllers\Customer;

use App\Models\Package;
use App\Models\PackageService;
use App\Models\Role;
use App\Http\Controllers\Controller;
use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use DataTables;
use Illuminate\Support\Str;

class PackageController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {

        can('package.view',true);
        if ($request->ajax()) {
            $data = Package::select('*');
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('paid_services', function($row){
                    $template = "";
                    if(!$row->services->isEmpty()){
                        foreach ($row->services as $service){
                            if($service->is_free==0) {
                                $template .= $service->service->name_en . "<br>";
                            }
                        }
                    }
                    return $template;
                })
                ->addColumn('created_by', function($row){
                    return (!empty($row->created_by_user)) ? $row->created_by_user->first_name.' '.$row->created_by_user->last_name:'';
                })
                ->addColumn('free_service', function($row){
                    $template = "";
                    if(!$row->services->isEmpty()){
                        foreach ($row->services as $service){
                            if($service->is_free==1) {
                                $template .= $service->service->name_en . "<br>";
                            }
                        }
                    }
                    return $template;
                })
                ->addColumn('action', function($row){
                    $btn = "";
                    if(can('package.edit')){
                        $btn.='<a href="" class="btn btn-primary btn-xs edit-package" data-id="'.$row->id.'" data-target="#editModal" data-toggle="modal">
                                    <i class="fa fa-edit"></i>
                                </a>';
                    }
                    if(can('package.delete')){
                        $btn.='<a href="'.set_route('package.delete',['id'=>$row->id]).'" class="btn btn-danger btn-xs delete-row">
                                    <i class="fa fa-close"></i>
                                </a>';
                    }
                    return $btn;
                })
                ->rawColumns(['action','paid_services','free_service'])
                ->make(true);
        }
        $services = Service::all();
        return view('package.index',compact('services'));
    }
    //create
    public function create(Request $request)
    {
        can('package.create',true);
        $roles = Role::all();
        return view('package.create',compact('roles'));
    }
    public function store(Request $request){
        can('package.create',true);
        $message_result = [];
        $validator = Validator::make($request->all(), [
            'name_en' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }else{
            $package = Package::create($request->all());
            if(!empty($package)){
                if(isset($request->paid_services) && !empty($request->paid_services)){
                    foreach ($request->paid_services as $paid_service){
                        PackageService::create([
                            'package_id'=>$package->id,
                            'service_id'=>$paid_service,
                            'is_free'=>0
                        ]);
                    }
                }
              if(isset($request->free_service) && !empty($request->free_service)){
				foreach ($request->free_service as $free_service){
					if (!empty($free_service)) {
						PackageService::create([
							'package_id'=>$package->id,
							'service_id'=>$free_service,
							'is_free'=>1
						]);
					}
				}
			}


            }
            set_message('Package was saved successfully.');
        }
        return response()->json(['success'=>true,'message'=>'Package was saved successfully.']);
    }
    //update
	public function edit(Request $request){
		$row = Package::find($request->get('id'));
		$free_service = []; 
		$services_id = [];
		if(!$row->services->isEmpty()){
			foreach ($row->services as $service){
				if($service->is_free==1){
					array_push($free_service, $service->service_id);
				}
				if($service->is_free==0){
					array_push($services_id, $service->service_id);
				}
			}
		}
		
		$row->free_service = $free_service;
		$row->services_id = $services_id;
		
		
		$services = Service::all();
		
		return response()->json(['success'=>true,'row'=>$row, 'services'=>$services]);
	}


    public function update(Request $request){
        can('package.edit',true);
        $data = $request->all();
         Package::where('id',$request->get('id'))->update(
            [
                'name_en'=>$request->get('name_en'),
                'name_ar'=>$request->get('name_ar'),
                'status'=>$request->get('status'),
            ]
        );
        $package = Package::find($request->get('id'));
        PackageService::where('package_id',$request->get('id'))->delete();
		
        if(isset($request->paid_services) && !empty($request->paid_services)){
            foreach ($request->paid_services as $paid_service){
                PackageService::create([
                    'package_id'=>$package->id,
                    'service_id'=>$paid_service,
                    'is_free'=>0
                ]);
            }
        }
       if(isset($request->free_service) && !empty($request->free_service)){
				foreach ($request->free_service as $free_service){
					if (!empty($free_service)) {
						PackageService::create([
							'package_id'=>$package->id,
							'service_id'=>$free_service,
							'is_free'=>1
						]);
					}
				}
			}
        return response()->json(['success'=>true,'message'=>'Package was saved successfully.']);
    }
    //delete
    public function destroy(Request $request){
        can('package.delete',true);
        PackageService::where('package_id',$request->route('id'))->delete();
        $row = Package::findOrFail($request->route('id'));
        $row->delete();
        set_message('Package was delete successfully.');
        return redirect()->back();
    }
}
