<?php



namespace App\Http\Controllers\Report;



use App\Http\Controllers\Booking\BookingController;

use App\Models\Booking;

use App\Models\Branch;

use App\Models\BuyProduct;

use App\Models\Shift;

use App\Models\Role;

use App\Models\UserUsedCard;

use App\Models\UserUsedDiscountCode;

use App\Models\UserWallet;

use App\Models\Worker;

use App\User;

use App\Models\SystemSettings;

use App\Http\Controllers\Controller;

use App\Models\Vacation;

use Carbon\Carbon;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Artisan;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Facades\Storage;

use Illuminate\Support\Facades\Validator;

use DataTables;

use DB;

use PDF;

use Dompdf\Dompdf;

use Dompdf\Options;



class ReportController extends Controller

{

    public function daily_report(Request $request)

    {

        $date = $request->get('date');

        $branch_id = $request->get('branch_id');

        $var = $date;

        if (empty($var)) {

            $var = date('d/m/Y');
        }

        $result = [];

        $users = [];

        $firstusers = [];

        $secondusers = [];

        $restusers = [];

        $report = "";

        $users_with_prices = [];

        $users_with_commission = [];

        $users_with_commission_staff = [];

        $users_with_tips = [];

        $payments_with_prices = [];

        $payments_type = [];

        $formattedDate = Carbon::now();

        if ($date)

            $formattedDate = Carbon::createFromFormat("d/m/Y", $date);

        $vacationsWorkerIds = Vacation::whereRaw('DATE(day)=\'' . $formattedDate->format("Y-m-d") . '\'')->get()->pluck("worker_id")->toArray();

        $temp_branches = Branch::where('id', '>', 0);

        if (get_user_role() != 1) {

            $temp_branches->where('id', Auth::user()->branch_id);
        }

        $branches = $temp_branches->get();

        $selected_branch = $request->get('branch_id');



        $product_details_prices = [

            'sales_cash' => 0,

            'sales_visa' => 0,

            'transfer_bank' => 0

        ];



        $wallet_details_prices = [

            'sales_cash' => 0,

            'sales_visa' => 0,
            
            'transfer_bank' => 0

        ];



        if (!empty($date)) {

            $date = convert_date($date);

            $date = date('Y-m-d', strtotime($date));



            $temp_report = Booking::whereRaw('booking_date="' . $date . '"')

                ->with('details');

            if (!empty($request->get('branch_id'))) {

                $temp_report->where('branch_id', $request->get('branch_id'));
            }

            $report = $temp_report->get();

            $payments_type = BookingController::get_payment_types();

            $payments_type_list = [];

            $payments_with_prices = [];

            foreach ($payments_type as $index => $item) {

                $payments_type_list[$index] = 0;

                $payments_with_prices[$index] = [];
            }



            $result = [];

            $users_with_prices = [];

            $users_with_commission = [];

            $users_with_commission_staff = [];

            $users_with_tips = [];

            $temp_users = Worker::where('id', '>', 0);

            if (get_user_role() != 1) {

                $temp_users->where('branch_id', Auth::user()->branch_id);
            }

            if (!empty($branch_id)) {

                $temp_users->where('branch_id', $branch_id);
            }

            $users = $temp_users->get();

            $firstusers = $temp_users->skip(0)->take(16)->get();

            $secondusers = $temp_users->skip(16)->take(33)->get();

            $restusers = $temp_users->skip(33)->get();

            foreach ($firstusers as $user) {

                $result[$user->id] = $payments_type_list;

                $users_with_prices[$user->id] = [];

                $users_with_commission[$user->id] = [];

                $users_with_commission_staff[$user->id] = [];

                $users_with_tips[$user->id] = [];
            }


            foreach ($secondusers as $user) {

                $result[$user->id] = $payments_type_list;

                $users_with_prices[$user->id] = [];

                $users_with_commission[$user->id] = [];

                $users_with_commission_staff[$user->id] = [];

                $users_with_tips[$user->id] = [];
            }

            foreach ($restusers as $user) {

                $result[$user->id] = $payments_type_list;

                $users_with_prices[$user->id] = [];

                $users_with_commission[$user->id] = [];

                $users_with_commission_staff[$user->id] = [];

                $users_with_tips[$user->id] = [];
            }

            $booking_with_discount = [];

            //check member ship cards

            $memberShipCardsUsers = [];

            $selected_memberShipCardsUsers = [];

            $temp_memberShipCards = UserUsedCard::with('booking', 'booking.details')

                ->whereRaw('DATE(created_at)="' . $date . '"');


            // if (get_user_role() == 1 || $selected_branch) {
            //     $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;
            //     $temp_memberShipCards->whereHas('booking', function ($query) use ($branch_id) {
            //         return $query->where('branch_id', $branch_id);
            //     });
            // }
            if ($selected_branch) {
                $temp_memberShipCards->whereHas('booking', function ($query) use ($selected_branch) {
                    return $query->where('branch_id', $selected_branch);
                });
            }

            $memberShipCards = $temp_memberShipCards->get();

            if (!$memberShipCards->isEmpty()) {

                foreach ($memberShipCards as $memberShipCard) {

                    $amount = $memberShipCard->amount;

                    if (!empty($memberShipCard->booking) && !empty($memberShipCard->booking->details)) {

                        foreach ($memberShipCard->booking->details as $detail) {

                            $worker = Worker::find($detail->worker_id);
                            $worker_commission = $worker->commission;
                            $salon_commission = 100 - $worker->commission;

                            // m.c
                            $worker_amount = ($detail->price * $worker_commission) / 100;
                            $worker_discount = $worker_amount * $amount / 100;

                            $salon_amount = ($detail->price * $salon_commission) / 100;
                            $salon_discount = $salon_amount * $amount / 100;

                            $user_amount = $worker_discount + $salon_discount;

                            if (isset($memberShipCardsUsers[$detail->worker_id])) {

                                $memberShipCardsUsers[$detail->worker_id]['amount'] += $user_amount;

                                $memberShipCardsUsers[$detail->worker_id]['amountArr'][] = $user_amount;

                                $memberShipCardsUsers[$detail->worker_id]['detailsArr'][] = $memberShipCard->booking;

                                $memberShipCardsUsers[$detail->worker_id]['codesArr'][] = $memberShipCard->code;
                            } else {

                                $memberShipCardsUsers[$detail->worker_id]['amount'] = $user_amount;

                                $memberShipCardsUsers[$detail->worker_id]['amountArr'][] = $user_amount;

                                $memberShipCardsUsers[$detail->worker_id]['detailsArr'][] = $memberShipCard->booking;

                                $memberShipCardsUsers[$detail->worker_id]['codesArr'][] = $memberShipCard->code;

                                $memberShipCardsUsers[$detail->worker_id]['code'] = $memberShipCard->code;

                                $memberShipCardsUsers[$detail->worker_id]['booking_id'] = $memberShipCard->booking->id;
                            }

                            //push to booking

                            if (isset($booking_with_discount[$memberShipCard->booking->id])) {

                                if (isset($booking_with_discount[$memberShipCard->booking->id][$detail->worker_id][$detail->service_id])) {

                                    $booking_with_discount[$memberShipCard->booking->id][$detail->worker_id][$detail->service_id] += $user_amount;
                                } else {

                                    $booking_with_discount[$memberShipCard->booking->id][$detail->worker_id][$detail->service_id] = $user_amount;
                                }
                            } else {

                                $booking_with_discount[$memberShipCard->booking->id][$detail->worker_id][$detail->service_id] = $user_amount;
                            }
                        }
                    }
                }
            }



            //check coupon

            $discountUsers = [];

            $selected_discountUsers = [];

            $temp_discount = UserUsedDiscountCode::with('booking', 'booking.details')->whereRaw('DATE(created_at)="' . $date . '"');


            // if (get_user_role() == 1 || $selected_branch) {
            //     $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;
            //     $temp_discount->whereHas('booking', function ($query) use ($branch_id) {
            //         return $query->where('branch_id', $branch_id);
            //     });
            // }
            if ($selected_branch) {
                $temp_discount->whereHas('booking', function ($query) use ($selected_branch) {
                    return $query->where('branch_id', $selected_branch);
                });
            }


            $discount = $temp_discount->get();

            if (!$discount->isEmpty()) {

                foreach ($discount as $static) {

                    $amount = $static->amount;
                    if (!empty($static->booking) && !empty($static->booking->details)) {

                        foreach ($static->booking->details as $detail) {

                            $worker = Worker::find($detail->worker_id);
                            $worker_commission = $worker->commission;
                            $salon_commission = 100 - $worker->commission;

                            // m.c
                            if ($static->type == "fixed") {
                                $worker_amount = 0;
                                $salon_amount = 0;
                                $worker_discount = 0;
                                $salon_discount = 0;
                            } else {
                                $worker_amount = ($detail->price * $worker_commission) / 100;
                                $worker_discount = $worker_amount * $amount / 100;

                                $salon_amount = ($detail->price * $salon_commission) / 100;
                                $salon_discount = $salon_amount * $amount / 100;
                            }

                            $user_amount = $worker_discount + $salon_discount;

                            $free = $worker_discount + $salon_discount;

                            if (isset($discountUsers[$detail->worker_id])) {

                                $discountUsers[$detail->worker_id]['amount'] += $free;

                                $discountUsers[$detail->worker_id]['amountArr'][] = $free;

                                $discountUsers[$detail->worker_id]['detailsArr'][] = $static->booking;

                                $discountUsers[$detail->worker_id]['codesArr'][] = $static->code;
                            } else {

                                $discountUsers[$detail->worker_id]['amount'] = $free;

                                $discountUsers[$detail->worker_id]['booking_id'] = $static->booking->id;

                                $discountUsers[$detail->worker_id]['amountArr'][] = $free;

                                $discountUsers[$detail->worker_id]['detailsArr'][] = $static->booking;

                                $discountUsers[$detail->worker_id]['codesArr'][] = $static->code;
                            }



                            //push to booking

                            if (isset($booking_with_discount[$static->booking->id])) {

                                if (isset($booking_with_discount[$static->booking->id][$detail->worker_id][$detail->service_id])) {

                                    $booking_with_discount[$static->booking->id][$detail->worker_id][$detail->service_id] += $user_amount;
                                } else {

                                    $booking_with_discount[$static->booking->id][$detail->worker_id][$detail->service_id] = $user_amount;
                                }
                            } else {

                                $booking_with_discount[$static->booking->id][$detail->worker_id][$detail->service_id] = $user_amount;
                            }
                        }
                    }
                }
            }

            // dd($discountUsers);



            //for report

            if (!$report->isEmpty()) {

                foreach ($report as $value) {

                    $full_name = $value->full_name;

                    $mobile = $value->mobile;

                    $price = 0;

                    if (!empty($value->details)) {
                        foreach ($value->details as $detail) {

                            if (isset($result[$detail->worker_id])) {

                                $price = $detail->price;

                                $payment_type_select = $value->payment_type;

                                if (empty($value->payment_type)) {

                                    $payment_type_select = 'wallet';
                                }

                                $result[$detail->worker_id][$payment_type_select] += $price;

                                array_push($users_with_prices[$detail->worker_id], $price);



                                if (!empty($detail->commission) /*&& $detail->commission != 0*/) {
                                    $commission = (int)$detail->price * $detail->commission / 100;

                                    if (UserUsedCard::where('booking_id', $detail->booking_id)->exists()) {
                                        $userUsedCard = UserUsedCard::where('booking_id', $detail->booking_id)->first();
                                        $amount = $userUsedCard->amount;

                                        $worker = Worker::find($detail->worker_id);
                                        $worker_commission = $worker->commission;
                                        $salon_commission = 100 - $worker->commission;
                                        
                                        $worker_amount = ($detail->price * $worker_commission) / 100;
                                        $worker_discount = $worker_amount * $amount / 100;

                                        $salon_amount = ($detail->price * $salon_commission) / 100;
                                        $salon_discount = $salon_amount * $amount / 100;

                                        $free = $worker_discount + $salon_discount;

                                        $user_amount = $detail->price - $free;

                                        $commission = $user_amount * $worker_commission / 100;

                                        $free_worker_commission = ($free * $worker_commission) / 100;

                                        $free_membership_to_commisssion = $free - $free_worker_commission;
                                        $commission += $free_membership_to_commisssion;
                                    }
                                    if (UserUsedDiscountCode::where('booking_id', $detail->booking_id)->exists()) {
                                        $userUsedDiscountCode = UserUsedDiscountCode::where('booking_id', $detail->booking_id)->first();
                                        $amount = $userUsedDiscountCode->amount;

                                        $worker = Worker::find($detail->worker_id);
                                        $worker_commission = $worker->commission;
                                        $salon_commission = 100 - $worker->commission;

                                        // m.c
                                        if ($userUsedDiscountCode->type == "fixed") {
                                            $worker_amount = 0;
                                            $salon_amount = 0;
                                            $worker_discount = 0;
                                            $salon_discount = 0;
                                        } else {
                                            $worker_amount = ($detail->price * $worker_commission) / 100;
                                            $worker_discount = $worker_amount * $amount / 100;

                                            $salon_amount = ($detail->price * $salon_commission) / 100;
                                            $salon_discount = $salon_amount * $amount / 100;
                                        }

                                        $user_amount = $worker_discount + $salon_discount;

                                        $commission = $user_amount * $amount / 100;

                                        $free = $worker_discount + $salon_discount;

                                        $free_worker_commission = ($free * $worker_commission) / 100;

                                        $free_discount_to_commisssion = $free - $free_worker_commission;
                                        $commission += $free_discount_to_commisssion;
                                    }

                                    array_push($users_with_commission[$detail->worker_id], $commission);
                                }

                                if (!empty($detail->commission_staff_worker_id) && !empty($detail->commission_staff)) {
                                    $commission = (int)$detail->price * $detail->commission_staff / 100;
                                    array_push($users_with_commission_staff[$detail->commission_staff_worker_id], $commission);
                                }



                                if (!empty($detail->tip) /*&& $detail->commission != 0*/) {

                                    array_push($users_with_tips[$detail->worker_id], $detail->tip);
                                }



                                //check if user has free

                                $free_price = 0;

                                if (isset($booking_with_discount[$value->id][$detail->worker_id][$detail->service_id])) {

                                    $free_price = $booking_with_discount[$value->id][$detail->worker_id][$detail->service_id];
                                }

                                //check for free service

                                if ($detail->is_free == 1) {

                                    $free_price += $detail->price;
                                }

                                $payments_with_prices[$payment_type_select][$detail->worker_id][] = $price - $free_price;

                                //for member ship free

                                if (isset($memberShipCardsUsers[$detail->worker_id]) && $value->id == $memberShipCardsUsers[$detail->worker_id]['booking_id'] && !in_array($detail->worker_id, $selected_memberShipCardsUsers)) {

                                    $temp = [];

                                    $temp['amount'] = $memberShipCardsUsers[$detail->worker_id]['amount'];

                                    $temp['details'] = $memberShipCardsUsers[$detail->worker_id]['amountArr'];

                                    $temp['detailsArr'] = $memberShipCardsUsers[$detail->worker_id]['detailsArr'];

                                    $temp['codesArr'] = $memberShipCardsUsers[$detail->worker_id]['codesArr'];

                                    $temp['type'] = "member_ship";

                                    $temp['code'] = $memberShipCardsUsers[$detail->worker_id]['code'];

                                    $temp['client_name'] = $full_name;

                                    $payments_with_prices["free"][$detail->worker_id][] = $temp;

                                    array_push($selected_memberShipCardsUsers, $detail->worker_id);
                                }

                                //for discount free

                                if (isset($discountUsers[$detail->worker_id]) && $value->id == $discountUsers[$detail->worker_id]['booking_id'] && !in_array($detail->worker_id, $selected_discountUsers)) {

                                    $temp = [];

                                    $temp['amount'] = $discountUsers[$detail->worker_id]['amount'];

                                    $temp['type'] = "discount_code";

                                    $temp['code'] = "";

                                    $temp['details'] = $discountUsers[$detail->worker_id]['amountArr'];

                                    $temp['detailsArr'] = $discountUsers[$detail->worker_id]['detailsArr'];

                                    $temp['codesArr'] = $discountUsers[$detail->worker_id]['codesArr'];

                                    $temp['client_name'] = $mobile;

                                    $payments_with_prices["free"][$detail->worker_id][] = $temp;

                                    //$payments_with_prices["free"][$detail->worker_id][] = $discountUsers[$detail->worker_id];

                                    array_push($selected_discountUsers, $detail->worker_id);
                                }

                                //for free services

                                if ($detail->is_free == 1) {

                                    $temp = [];

                                    $temp['amount'] = $detail->price;

                                    $temp['type'] = "free_service";

                                    $temp['code'] = "";

                                    $temp['client_name'] = $mobile;

                                    $payments_with_prices["free"][$detail->worker_id][] = $temp;
                                }
                            }
                        }
                    }
                }
            }

            //get for products

            //dd($users_with_commission);

            $temp_BuyProduct = BuyProduct::select('buy_products.*')

                ->with('details')

                ->leftJoin('workers', 'workers.id', '=', 'buy_products.worker_id')

                ->whereRaw('DATE(buy_products.created_at)="' . $date . '"');


            // if (get_user_role() == 1 || $selected_branch) {
            //     $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;
            //     $temp_BuyProduct = $temp_BuyProduct->where('workers.branch_id', $branch_id);
            // }
            if ($selected_branch) {
                $temp_BuyProduct = $temp_BuyProduct->where(function($query) use ($selected_branch) {
                    $query->where('workers.branch_id', $selected_branch)
                          ->orWhereNull('buy_products.worker_id'); // Include records without worker_id
                });
            }


            $BuyProduct = $temp_BuyProduct->get();

            //dd($BuyProduct);

            if (!empty($BuyProduct)) {

                foreach ($BuyProduct as $BuyProduct_item) {

                    $date = date('Y-m-d', strtotime($BuyProduct_item->created_at));

                    $temp = [

                        "amount" => 0,

                        "products" => []

                    ];

                    if (!$BuyProduct_item->details->isEmpty()) {

                        $orderPrice = 0;

                        foreach ($BuyProduct_item->details as $detail) {

                            if (isset($product_details_prices[$BuyProduct_item->payment_type])) {

                                $product_price = $detail->price;

                                if (!empty($BuyProduct_item->discount)) {

                                    $product_price -= ($product_price * $BuyProduct_item->discount) / 100;
                                }

                                $product_details_prices[$BuyProduct_item->payment_type] += $product_price;

                                $orderPrice += $product_price;

                                $temp["products"][] = $detail;

                                // $payments_with_prices[$BuyProduct_item->payment_type][$BuyProduct_item->worker_id][] = ["amount" => $product_price];

                                // $payments_with_prices[$BuyProduct_item->payment_type] += $product_price;

                            }
                        }

                        //LAMA

                        if (!empty($BuyProduct_item->sales_worker_id) && isset($result[$BuyProduct_item->sales_worker_id][$BuyProduct_item->payment_type])) {

                            $result[$BuyProduct_item->sales_worker_id][$BuyProduct_item->payment_type] += $orderPrice;

                            // array_push($users_with_prices[$BuyProduct_item->sales_worker_id], $orderPrice);

                            $temp["amount"] = $orderPrice;

                            $payments_with_prices[$BuyProduct_item->payment_type][$BuyProduct_item->sales_worker_id][] = $temp;
                        } else {
                            // Handle case where sales_worker_id is NULL or not found in result
                            // Add to product_details_prices to ensure amount is counted
                            if (isset($product_details_prices[$BuyProduct_item->payment_type])) {
                                $product_details_prices[$BuyProduct_item->payment_type] += $orderPrice;
                            }
                        }
                    }

                    //worker commission

                    if (!empty($BuyProduct_item->worker_id) && isset($users_with_commission[$BuyProduct_item->worker_id])) {

                        array_push($users_with_commission[$BuyProduct_item->worker_id], $BuyProduct_item->commission);
                    }



                    if (!empty($BuyProduct_item->worker_id) && isset($users_with_tips[$BuyProduct_item->worker_id])) {

                        array_push($users_with_tips[$BuyProduct_item->worker_id], $BuyProduct_item->tip);
                    }
                }
            }

            // dd($product_details_prices);



            //get for wallet

            $temp_get_wallets = UserWallet::whereRaw('DATE(users_wallets.created_at)="' . $date . '"');

            // if (get_user_role() == 1 || $selected_branch) {
            //     $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;
            //     $temp_get_wallets = $temp_get_wallets->join('users', 'users.id', '=', 'users_wallets.created_by')
            //         ->where('users.branch_id', $branch_id);
            // }
            if ($selected_branch) {
                $temp_get_wallets = $temp_get_wallets->join('users', 'users.id', '=', 'users_wallets.created_by')
                    ->where('users.branch_id', $selected_branch);
            }

            $get_wallets = $temp_get_wallets->get();



            if (!$get_wallets->isEmpty()) {

                foreach ($get_wallets as $get_wallet) {

                    if (isset($wallet_details_prices[$get_wallet->wallet_type])) {

                        $wallet_details_prices[$get_wallet->wallet_type] += $get_wallet->invoiced_amount;

                        //worker commission

                        if (isset($users_with_commission[$get_wallet->worker_id])) {
                            $commission = (int)$get_wallet->invoiced_amount * $get_wallet->commission / 100;
                            array_push($users_with_commission[$get_wallet->worker_id], $commission);
                        }



                        if (isset($users_with_tips[$get_wallet->worker_id])) {

                            array_push($users_with_tips[$get_wallet->worker_id], $get_wallet->tip);
                        }
                    }
                }
            }
        }

        //dd(get_user_role());

        // dd($users_with_commission);

        // dd(compact('result', 'firstusers', 'secondusers', 'restusers', 'var', 'report', 'users_with_prices', 'payments_with_prices', 'payments_type', 'product_details_prices', 'wallet_details_prices', 'users_with_commission'));

        // return view('report.template.daily_report', compact('result', 'firstusers', 'secondusers', 'restusers', 'var', 'report', 'users_with_prices', 'payments_with_prices', 'payments_type', 'product_details_prices', 'wallet_details_prices', 'users_with_commission','vacationsWorkerIds'));

        $is_pdf = false;
        if (isset($request->is_pdf)) {
            $is_pdf = true;
        }

        $template = (string)view('report.template.daily_report', compact(
            'report',
            'result',
            'users',
            'firstusers',
            'secondusers',
            'restusers',
            'var',
            'report',
            'users_with_prices',
            'payments_with_prices',
            'payments_type',
            'product_details_prices',
            'wallet_details_prices',
            'users_with_commission',
            'users_with_commission_staff',
            'users_with_tips',
            'vacationsWorkerIds',
            'is_pdf'
        ));

        if (isset($request->is_pdf)) {

            $pdf = PDF::loadView('report.pdf.daily_report', compact(
                'result',
                'users',
                'firstusers',
                'secondusers',
                'restusers',
                'var',
                'report',
                'users_with_prices',
                'payments_with_prices',
                'payments_type',
                'product_details_prices',
                'template',
                'wallet_details_prices',
                'is_pdf'
            ))->setPaper('a4', 'landscape');

            return $pdf->stream('pdfview.pdf');
        }

        return view('report.daily_report', compact(
            'date',
            'var',
            'template',
            'branches',
            'selected_branch',
            'product_details_prices',
            'request',
            'wallet_details_prices',
            'users_with_commission',
            'users_with_commission_staff',
            'users_with_tips',
            'is_pdf'
        ));
    }









    public function sales(Request $request)

    {

        $branch_id = $request->get('branch_id');

        $years = Booking::select(DB::raw('DISTINCT YEAR(booking_date) as year'))

            ->get();

        $selected_year = $request->get('year');

        $selected_month = $request->get('month');

        $temp_branches = Branch::where('id', '>', 0);

        if (get_user_role() != 1) {

            $temp_branches->where('id', Auth::user()->branch_id);
        }

        $branches = $temp_branches->get();

        $selected_branch = $request->get('branch_id');

        $template = "";

        if (!empty($request->year)) {

            $temp_report = Booking::whereRaw('YEAR(booking_date)="' . $request->get('year') . '"')

                ->whereRaw('MONTH(booking_date)="' . $request->get('month') . '"')

                ->with('details');

            if (!empty($request->get('branch_id'))) {

                $temp_report->where('branch_id', $request->get('branch_id'));
            }



            $report = $temp_report->get();

            $payments_type = BookingController::get_payment_types();

            $last_total = [];

            foreach ($payments_type as $index => $value) {

                $last_total[$index] = 0;
            }

            $payments_type['commission'] = __('s.commission');

            $last_total['commission'] = 0;

            $last_total['total_without_free'] = 0;

            $result = [];

            $days = cal_days_in_month(CAL_GREGORIAN, $request->get('month'), $request->get('year'));

            for ($i = 1; $i <= $days; $i++) {

                $month = ($request->get('month') <= 9) ? "0" . $request->get('month') : $request->get('month');

                $day = ($i <= 9) ? "0" . $i : $i;

                $date = $request->get('year') . "-" . $month . "-" . $day;

                $temp = [];

                foreach ($payments_type as $index => $value) {

                    $temp[$index] = 0;
                }

                $temp['commission'] = 0;

                $result[$date] = $temp;
            }

            if (!$report->isEmpty()) {

                foreach ($report as $value) {

                    $price = 0;

                    if (isset($result[$value->booking_date])) {

                        if (!$value->details->isEmpty()) {

                            foreach ($value->details as $detail) {

                                $price += $detail->price;

                                if ($detail->is_free == 1) {

                                    $result[$value->booking_date]['free'] += $detail->price;

                                    //LAMA

                                    $price -= $detail->price;
                                }

                                $result[$value->booking_date]['commission'] += $detail->commission;
                            }
                        }

                        $selected_payment_type = $value->payment_type;

                        if (empty($value->payment_type)) {

                            $selected_payment_type = "wallet";
                        }

                        $result[$value->booking_date][$selected_payment_type] += $price;
                    }
                }
            }



            //for Free

            $temp_memberShipCards = UserUsedCard::with('booking', 'booking.details')->whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"');

            if (get_user_role() == 1 || $selected_branch) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_memberShipCards->whereHas('booking', function ($query) use ($branch_id) {

                    return $query->where('branch_id', $branch_id);
                });
            }

            $memberShipCards = $temp_memberShipCards->get();

            if (!$memberShipCards->isEmpty()) {

                foreach ($memberShipCards as $memberShipCard) {

                    $selected_payment_type = $memberShipCard->booking->payment_type;

                    if (empty($memberShipCard->booking->payment_type)) {

                        $selected_payment_type = "wallet";
                    }

                    $amount = $memberShipCard->amount;

                    if (!empty($memberShipCard->booking) && !empty($memberShipCard->booking->details)) {

                        foreach ($memberShipCard->booking->details as $detail) {

                            if (in_array($memberShipCard->booking->booking_date, array_keys($result))) {

                                $user_amount = ($detail->price * $amount) / 100;

                                $result[$memberShipCard->booking->booking_date]['free'] += $user_amount;

                                $result[$memberShipCard->booking->booking_date][$selected_payment_type] -= $user_amount;
                            }
                        }
                    }
                }
            }

            $temp_discount = UserUsedDiscountCode::with('booking', 'booking.details')->whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"');

            if (get_user_role() == 1 || $selected_branch) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_discount->whereHas('booking', function ($query) use ($branch_id) {

                    return $query->where('branch_id', $branch_id);
                });
            }

            $discount = $temp_discount->get();

            $discountsArr = [];

            if (!$discount->isEmpty()) {

                foreach ($discount as $static) {

                    $amount = $static->amount;

                    if (!empty($static->booking) && !empty($static->booking->details)) {

                        $selected_payment_type = $static->booking->payment_type;

                        if (empty($static->booking->payment_type)) {

                            $selected_payment_type = "wallet";
                        }

                        foreach ($static->booking->details as $detail) {

                            if ($static->type == "fixed") {

                                $user_amount = $amount;
                            } else {

                                $user_amount = ($detail->price * $amount) / 100;
                            }

                            if (isset($result[$static->booking->booking_date])) {

                                $result[$static->booking->booking_date]['free'] += $user_amount;

                                //LAMA

                                $result[$static->booking->booking_date][$selected_payment_type] -= $user_amount;
                            }
                        }
                    }
                }
            }

            //get sales cash and sales visa
            $temp_users_wallets = UserWallet::whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"');
            if (get_user_role() == 1 || $branch_id) {
                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;
                $temp_users_wallets->whereHas('created_by_user', function ($query) use ($branch_id) {
                    return $query->where('branch_id', $branch_id);
                });
            }

            $users_wallets = $temp_users_wallets->get();
            if (!empty($users_wallets)) {
                foreach ($users_wallets as $users_wallet) {
                    $date = date('Y-m-d', strtotime($users_wallet->created_at));
                    if ($users_wallet->wallet_type == "sales_visa") {
                        $result[$date]['sales_visa_cp'] += $users_wallet->invoiced_amount;
                    } else if ($users_wallet->wallet_type == "transfer_bank") {
                        $result[$date]['transfer_bank'] += $users_wallet->invoiced_amount;
                    } else {
                        $result[$date]['sales_cash_cp'] += $users_wallet->invoiced_amount;
                    }

                    //worker commission
                    if (!empty($users_wallet->commission)) {
                        $result[$date]['commission'] += $users_wallet->commission;
                    }
                }
            }

            //get for products

            $temp_BuyProduct = BuyProduct::whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"')->with('details');

            if (get_user_role() == 1 || $branch_id) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_BuyProduct->whereHas('created_by_user', function ($query) use ($branch_id) {

                    return $query->where('branch_id', $branch_id);
                });
            }

            $BuyProduct = $temp_BuyProduct->get();

            if (!empty($BuyProduct)) {

                foreach ($BuyProduct as $BuyProduct_item) {

                    $date = date('Y-m-d', strtotime($BuyProduct_item->created_at));

                    if (!$BuyProduct_item->details->isEmpty()) {

                        foreach ($BuyProduct_item->details as $detail) {

                            if (isset($result[$date][$BuyProduct_item->payment_type])) {

                                $product_price = $detail->price;

                                if (!empty($BuyProduct_item->discount)) {

                                    $product_price -= ($product_price * $BuyProduct_item->discount) / 100;
                                }

                                $result[$date][$BuyProduct_item->payment_type] += $product_price;
                            }
                        }
                    }

                    //worker commission

                    if (!empty($BuyProduct_item->commission)) {

                        $result[$date]['commission'] += $BuyProduct_item->commission;
                    }
                }
            }

            $template = (string)view('report.template.sales_report', compact('result', 'payments_type', 'last_total'));



            if (isset($request->is_pdf)) {

                $pdf = PDF::loadView('report.pdf.sales_report', compact('result', 'payments_type', 'last_total', 'template'))->setPaper('a4', 'landscape');

                return $pdf->stream('pdfview.pdf');
            }
        }

        return view('report.sales_report', compact('years', 'template', 'selected_year', 'selected_month', 'branches', 'selected_branch', 'request'));
    }

    public function staff(Request $request)

    {

        $branch_id = $request->get('branch_id');

        $years = Booking::select(DB::raw('DISTINCT YEAR(booking_date) as year'))

            ->get();

        $selected_year = $request->get('year');

        $selected_month = $request->get('month');

        $template = "";

        $temp_branches = Branch::where('id', '>', 0);

        if (get_user_role() != 1) {

            $temp_branches->where('id', Auth::user()->branch_id);
        }

        $branches = $temp_branches->get();

        $selected_branch = $request->get('branch_id');

        $vacationsWorkerDays = Vacation::get()->toArray();



        $vacationsWorkerIds = [];

        if (!empty($request->year)) {

            $temp_report = Booking::whereRaw('YEAR(booking_date)="' . $request->get('year') . '"')

                ->whereRaw('MONTH(booking_date)="' . $request->get('month') . '"')

                ->with('details');



            if (!empty($request->get('branch_id'))) {

                $temp_report->where('branch_id', $request->get('branch_id'));
            }

            $report = $temp_report->get();

            $temp_users = Worker::where('id', '>', 0);

            if (get_user_role() != 1) {

                $temp_users->where('branch_id', Auth::user()->branch_id);
            }

            if (!empty($branch_id)) {

                $temp_users->where('branch_id', $branch_id);
            }

            $firstusers = $temp_users->skip(0)->take(16)->get();

            $firstusers_last_total = [];

            $firstusers_last_total_price = [];

            $firstusers_last_total_tips = [];

            $secondusers = $temp_users->skip(16)->take(33)->get();

            $secondusers_last_total = [];

            $secondusers_last_total_price = [];

            $secondusers_last_total_tips = [];

            $restusers = $temp_users->skip(33)->get();

            $restusers_last_total = [];

            $restusers_last_total_price = [];

            $restusers_last_total_tips = [];



            foreach ($firstusers as $index => $value) {

                $firstusers_last_total[$value->id] = 0;

                $firstusers_last_total_price[$value->id] = 0;

                $firstusers_last_total_tips[$value->id] = 0;
            }

            foreach ($secondusers as $index => $value) {

                $secondusers_last_total[$value->id] = 0;

                $secondusers_last_total_price[$value->id] = 0;

                $secondusers_last_total_tips[$value->id] = 0;
            }

            foreach ($restusers as $index => $value) {

                $restusers_last_total[$value->id] = 0;

                $restusers_last_total_price[$value->id] = 0;

                $restusers_last_total_tips[$value->id] = 0;
            }

            $result = [];

            //for free

            $memberShipCardsUsers = [];

            $discountUsers = [];



            $days = cal_days_in_month(CAL_GREGORIAN, $request->get('month'), $request->get('year'));

            for ($i = 1; $i <= $days; $i++) {

                $month = ($request->get('month') <= 9) ? "0" . $request->get('month') : $request->get('month');

                $day = ($i <= 9) ? "0" . $i : $i;

                $date = $request->get('year') . "-" . $month . "-" . $day;

                $temp = [];

                foreach ($firstusers as $index => $value) {

                    $temp[$value->id] = 0;
                }

                foreach ($secondusers as $index => $value) {

                    $temp[$value->id] = 0;
                }

                foreach ($restusers as $index => $value) {

                    $temp[$value->id] = 0;
                }

                $result['price'][$date] = $temp;

                $result['tips'][$date] = $temp;

                $memberShipCardsUsers[$date] = $temp;

                $discountUsers[$date] = $temp;

                $vacationsWorkerIds[$date] = array_values(array_filter($vacationsWorkerDays, function ($e) use ($date) {

                    return $e["day"] == $date;
                }));

                $temp = [];

                foreach ($vacationsWorkerIds[$date] as $item) {

                    $temp[] = $item["worker_id"];
                }

                $vacationsWorkerIds[$date] = $temp;
            }

            // dd($vacationsWorkerIds);

            //check member ship cards

            $selected_memberShipCardsUsers = [];



            //for report

            if (isset($result['price']) && isset($result['tips'])) {



                if (!$report->isEmpty()) {

                    foreach ($report as $value) {

                        $price = 0;

                        $tip = 0;

                        if (isset($result['price'][$value->booking_date]) && isset($result['tips'][$value->booking_date])) {

                            if (!$value->details->isEmpty()) {

                                foreach ($value->details as $detail) {

                                    if (!isset($result['price'][$value->booking_date][$detail->worker_id]) && !isset($result['tips'][$value->booking_date][$detail->worker_id])) {

                                        continue;
                                    }

                                    $price = $detail->price;

                                    $tip = $detail->tip;

                                    $result['price'][$value->booking_date][$detail->worker_id] += $price;

                                    $result['tips'][$value->booking_date][$detail->worker_id] += $tip;
                                }
                            }
                        }
                    }
                }
            }

            //remove for free

            if (!empty($result)) {

                foreach ($result as $date => $workers_list) {

                    foreach ($workers_list as $worker_id => $price) {

                        if (isset($memberShipCardsUsers[$date][$worker_id])) {

                            $result[$date][$worker_id] -= $memberShipCardsUsers[$date][$worker_id];
                        }



                        if (isset($discountUsers[$date][$worker_id])) {

                            $result[$date][$worker_id] -= $discountUsers[$date][$worker_id];
                        }
                    }
                }
            }



            $template = (string)view('report.template.staff_report', compact(
                'result',
                'firstusers',
                'secondusers',
                'restusers',

                'firstusers_last_total',
                'firstusers_last_total_price',
                'firstusers_last_total_tips',
                'secondusers_last_total',
                'secondusers_last_total_price',
                'secondusers_last_total_tips',

                'restusers_last_total',
                'restusers_last_total_price',
                'restusers_last_total_tips',
                'vacationsWorkerIds'
            ));



            if (isset($request->is_pdf)) {

                $pdf = PDF::loadView('report.pdf.staff_report', compact(
                    'result',
                    'firstusers',
                    'secondusers',
                    'restusers',

                    'firstusers_last_total',
                    'firstusers_last_total_price',
                    'firstusers_last_total_tips',
                    'secondusers_last_total',
                    'secondusers_last_total_price',
                    'secondusers_last_total_tips',

                    'restusers_last_total',
                    'restusers_last_total_price',
                    'restusers_last_total_tips',
                    'template'
                ))->setPaper('a4', 'landscape');

                return $pdf->stream('pdfview.pdf');
            }
        }







        return view('report.staff_report', compact('years', 'template', 'selected_year', 'selected_month', 'branches', 'selected_branch', 'request', 'vacationsWorkerIds'));
    }

    public function staff_tips(Request $request)

    {

        $branch_id = $request->get('branch_id');

        $all_users = [];

        $years = Booking::select(DB::raw('DISTINCT YEAR(booking_date) as year'))

            ->get();

        $selected_year = $request->get('year');

        $selected_month = $request->get('month');

        $template = "";

        $temp_branches = Branch::where('id', '>', 0);

        if (get_user_role() != 1) {

            $temp_branches->where('id', Auth::user()->branch_id);
        }

        $branches = $temp_branches->get();

        $selected_branch = $request->get('branch_id');

        $selected_worker = $request->get('worker_id');

        // print($selected_worker);

        $vacationsWorkerDays = Vacation::get()->toArray();



        $vacationsWorkerIds = [];

        if (!empty($request->year)) {

            $temp_report = Booking::whereRaw('YEAR(booking_date)="' . $request->get('year') . '"')

                ->whereRaw('MONTH(booking_date)="' . $request->get('month') . '"')

                ->with('details');



            if (!empty($request->get('branch_id'))) {

                $temp_report->where('branch_id', $request->get('branch_id'));
            }

            $report = $temp_report->get();



            if (empty($selected_worker)) {
                $temp_users = Worker::where('id', '>', 0);

                if (get_user_role() != 1) {

                    $temp_users->where('branch_id', Auth::user()->branch_id);
                }
            } else {
                $temp_users = Worker::where('id', '=', $selected_worker);

                if (get_user_role() != 1) {

                    $temp_users->where('branch_id', Auth::user()->branch_id);
                }
            }



            if (!empty($branch_id)) {

                $temp_users->where('branch_id', $branch_id);
            }

            $firstusers = $temp_users->skip(0)->take(16)->get();

            $firstusers_last_total = [];

            $firstusers_last_total_price = [];

            $firstusers_last_total_tips = [];

            $secondusers = $temp_users->skip(16)->take(33)->get();

            $secondusers_last_total = [];

            $secondusers_last_total_price = [];

            $secondusers_last_total_tips = [];

            $restusers = $temp_users->skip(33)->get();

            $restusers_last_total = [];

            $restusers_last_total_price = [];

            $restusers_last_total_tips = [];





            foreach ($firstusers as $index => $value) {

                $firstusers_last_total[$value->id] = 0;

                $firstusers_last_total_price[$value->id] = 0;

                $firstusers_last_total_tips[$value->id] = 0;
            }

            foreach ($secondusers as $index => $value) {

                $secondusers_last_total[$value->id] = 0;

                $secondusers_last_total_price[$value->id] = 0;

                $secondusers_last_total_tips[$value->id] = 0;
            }

            foreach ($restusers as $index => $value) {

                $restusers_last_total[$value->id] = 0;

                $restusers_last_total_price[$value->id] = 0;

                $restusers_last_total_tips[$value->id] = 0;
            }

            $result = [];

            //for free

            $memberShipCardsUsers = [];

            $discountUsers = [];



            $days = cal_days_in_month(CAL_GREGORIAN, $request->get('month'), $request->get('year'));

            for ($i = 1; $i <= $days; $i++) {

                $month = ($request->get('month') <= 9) ? "0" . $request->get('month') : $request->get('month');

                $day = ($i <= 9) ? "0" . $i : $i;

                $date = $request->get('year') . "-" . $month . "-" . $day;

                $temp = [];

                foreach ($firstusers as $index => $value) {

                    $temp[$value->id] = 0;
                }

                foreach ($secondusers as $index => $value) {

                    $temp[$value->id] = 0;
                }

                foreach ($restusers as $index => $value) {

                    $temp[$value->id] = 0;
                }

                $result['price'][$date] = $temp;

                $result['tips'][$date] = $temp;

                $memberShipCardsUsers[$date] = $temp;

                $discountUsers[$date] = $temp;

                $vacationsWorkerIds[$date] = array_values(array_filter($vacationsWorkerDays, function ($e) use ($date) {

                    return $e["day"] == $date;
                }));

                $temp = [];

                foreach ($vacationsWorkerIds[$date] as $item) {

                    $temp[] = $item["worker_id"];
                }

                $vacationsWorkerIds[$date] = $temp;
            }

            // dd($vacationsWorkerIds);

            //check member ship cards

            $selected_memberShipCardsUsers = [];



            //for report

            if (isset($result['price']) && isset($result['tips'])) {



                if (!$report->isEmpty()) {

                    foreach ($report as $value) {

                        $price = 0;

                        $tip = 0;

                        if (isset($result['price'][$value->booking_date]) && isset($result['tips'][$value->booking_date])) {

                            if (!$value->details->isEmpty()) {

                                foreach ($value->details as $detail) {

                                    if (!isset($result['price'][$value->booking_date][$detail->worker_id]) && !isset($result['tips'][$value->booking_date][$detail->worker_id])) {

                                        continue;
                                    }

                                    $price = $detail->price;

                                    $tip = $detail->tip;

                                    $result['price'][$value->booking_date][$detail->worker_id] += $price;

                                    $result['tips'][$value->booking_date][$detail->worker_id] += $tip;
                                }
                            }
                        }
                    }
                }
            }

            //remove for free

            if (!empty($result)) {

                foreach ($result as $date => $workers_list) {

                    foreach ($workers_list as $worker_id => $price) {

                        if (isset($memberShipCardsUsers[$date][$worker_id])) {

                            $result[$date][$worker_id] -= $memberShipCardsUsers[$date][$worker_id];
                        }



                        if (isset($discountUsers[$date][$worker_id])) {

                            $result[$date][$worker_id] -= $discountUsers[$date][$worker_id];
                        }
                    }
                }
            }





            $template = (string)view('report.template.tips_report', compact(
                'result',
                'firstusers',
                'secondusers',
                'restusers',

                'firstusers_last_total',
                'firstusers_last_total_price',
                'firstusers_last_total_tips',
                'secondusers_last_total',
                'secondusers_last_total_price',
                'secondusers_last_total_tips',

                'restusers_last_total',
                'restusers_last_total_price',
                'restusers_last_total_tips',
                'vacationsWorkerIds'
            ));



            if (isset($request->is_pdf)) {

                $pdf = PDF::loadView('report.pdf.tips_report', compact(
                    'result',
                    'firstusers',
                    'secondusers',
                    'restusers',

                    'firstusers_last_total',
                    'firstusers_last_total_price',
                    'firstusers_last_total_tips',
                    'secondusers_last_total',
                    'secondusers_last_total_price',
                    'secondusers_last_total_tips',

                    'restusers_last_total',
                    'restusers_last_total_price',
                    'restusers_last_total_tips',
                    'template'
                ))->setPaper('a4', 'landscape');

                return $pdf->stream('pdfview.pdf');
            }

            if (isset($request->is_print)) {

                $pdf = new Dompdf();

                $pdf->setPaper(array(0, 0, 226, 800));

                $GLOBALS['bodyHeight'] = 0;

                $pdf->setCallbacks(

                    array(

                        'myCallbacks' => array(

                            'event' => 'end_frame',
                            'f' => function ($infos) {

                                $frame = $infos["frame"];

                                if (strtolower($frame->get_node()->nodeName) === "body") {

                                    $padding_box = $frame->get_padding_box();

                                    $GLOBALS['bodyHeight'] += $padding_box['h'];
                                }
                            }

                        )

                    )

                );

                $pdf->loadHtml(view('report.worker_tips_report', compact(
                    'selected_worker',
                    'result',
                    'firstusers',
                    'secondusers',
                    'restusers',

                    'firstusers_last_total',
                    'firstusers_last_total_price',
                    'firstusers_last_total_tips',
                    'secondusers_last_total',
                    'secondusers_last_total_price',
                    'secondusers_last_total_tips',

                    'restusers_last_total',
                    'restusers_last_total_price',
                    'restusers_last_total_tips',
                    'template'
                ))->render());

                $pdf->render();

                unset($pdf);

                $pdf = PDF::loadView('report.worker_tips_report', compact(
                    'selected_worker',
                    'result',
                    'firstusers',
                    'secondusers',
                    'restusers',

                    'firstusers_last_total',
                    'firstusers_last_total_price',
                    'firstusers_last_total_tips',
                    'secondusers_last_total',
                    'secondusers_last_total_price',
                    'secondusers_last_total_tips',

                    'restusers_last_total',
                    'restusers_last_total_price',
                    'restusers_last_total_tips',
                    'template'
                ));

                // $pdf->dompdf->set_option('dpi' , '512');

                $pdf->setPaper(array(0, 0, 226, $GLOBALS['bodyHeight'] + 50));

                return $pdf->stream('pdfview.pdf');
            }
        }



        if (empty($all_users)) {
            $temp_users = Worker::where('id', '>', 0);

            if (get_user_role() != 1) {

                $temp_users->where('branch_id', Auth::user()->branch_id);
            }



            // $all_users = $temp_users ->skip(0)->take(33)->get();

            $all_users = $temp_users->get();
        }



        // dd( $all_users as $index=>$value);



        return view('report.tips_report', compact('years', 'template', 'selected_year', 'selected_month', 'branches', 'all_users', 'selected_branch', 'selected_worker', 'request', 'vacationsWorkerIds'));
    }



    // public function staff_tips(Request $request)

    // {

    //     $branch_id = $request->get('branch_id');

    //     $all_users = [];

    //     $years = Booking::select(DB::raw('DISTINCT YEAR(booking_date) as year'))

    //         ->get();

    //     $selected_year = $request->get('year');

    //     $selected_month = $request->get('month');

    //     $template = "";

    //     $temp_branches = Branch::where('id', '>', 0);

    //     if (get_user_role() != 1) {

    //         $temp_branches->where('id', Auth::user()->branch_id);

    //     }

    //     $branches = $temp_branches->get();

    //     $selected_branch = $request->get('branch_id');

    //     $selected_worker = $request->get('worker_id');

    //     print($selected_worker);

    //     $vacationsWorkerDays = Vacation::get()->toArray();



    //     $vacationsWorkerIds = [];

    //     if (!empty($request->year)) {

    //         $temp_report = Booking::whereRaw('YEAR(booking_date)="' . $request->get('year') . '"')

    //             ->whereRaw('MONTH(booking_date)="' . $request->get('month') . '"')

    //             ->with('details');



    //         if (!empty($request->get('branch_id'))) {

    //             $temp_report->where('branch_id', $request->get('branch_id'));

    //         }

    //         $report = $temp_report->get();



    //         if(empty($selected_worker))    

    //           { $temp_users = Worker::where('id', '>', 0);

    //             if (get_user_role() != 1) {

    //                 $temp_users->where('branch_id', Auth::user()->branch_id);

    //             }}

    //         else 

    //         {$temp_users = Worker::where('id', '=', $selected_worker);

    //         if (get_user_role() != 1) {

    //             $temp_users->where('branch_id', Auth::user()->branch_id);

    //         }}



    //         if (!empty($branch_id)) {

    //             $temp_users->where('branch_id', $branch_id);

    //         }

    //         $firstusers = $temp_users ->skip(0)->take(16)->get();

    //         $firstusers_last_total = [];

    //         $firstusers_last_total_price = [];

    //         $firstusers_last_total_tips = [];

    //         $secondusers = $temp_users ->skip(16)->take(33)->get();

    //         $secondusers_last_total = [];

    //         $secondusers_last_total_price = [];

    //         $secondusers_last_total_tips = [];

    //         $restusers = $temp_users ->skip(33)->get();

    //         $restusers_last_total = [];

    //         $restusers_last_total_price = [];

    //         $restusers_last_total_tips = [];





    //         foreach ($firstusers as $index => $value) {

    //             $firstusers_last_total[$value->id] = 0;

    //             $firstusers_last_total_price[$value->id] = 0;

    //             $firstusers_last_total_tips[$value->id] = 0;

    //         }

    //         foreach ($secondusers as $index => $value) {

    //             $secondusers_last_total[$value->id] = 0;

    //             $secondusers_last_total_price[$value->id] = 0;

    //             $secondusers_last_total_tips[$value->id] = 0;

    //         }

    //         foreach ($restusers as $index => $value) {

    //             $restusers_last_total[$value->id] = 0;

    //             $restusers_last_total_price[$value->id] = 0;

    //             $restusers_last_total_tips[$value->id] = 0;

    //         }

    //         $result = [];

    //         //for free

    //         $memberShipCardsUsers = [];

    //         $discountUsers = [];



    //         $days = cal_days_in_month(CAL_GREGORIAN, $request->get('month'), $request->get('year'));

    //         for ($i = 1; $i <= $days; $i++) {

    //             $month = ($request->get('month') <= 9) ? "0" . $request->get('month') : $request->get('month');

    //             $day = ($i <= 9) ? "0" . $i : $i;

    //             $date = $request->get('year') . "-" . $month . "-" . $day;

    //             $temp = [];

    //             foreach ($firstusers as $index => $value) {

    //                 $temp[$value->id] = 0;

    //             }

    //             foreach ($secondusers as $index => $value) {

    //                 $temp[$value->id] = 0;

    //             }

    //             foreach ($restusers as $index => $value) {

    //                 $temp[$value->id] = 0;

    //             }

    //             $result['price'][$date] = $temp;

    //             $result['tips'][$date] = $temp;

    //             $memberShipCardsUsers[$date] = $temp;

    //             $discountUsers[$date] = $temp;

    //             $vacationsWorkerIds[$date] = array_values(array_filter($vacationsWorkerDays, function ($e) use ($date) {

    //                 return $e["day"] == $date;

    //             }));

    //             $temp = [];

    //             foreach ($vacationsWorkerIds[$date] as $item) {

    //                 $temp[] = $item["worker_id"];

    //             }

    //             $vacationsWorkerIds[$date] = $temp;

    //         }

    //         // dd($vacationsWorkerIds);

    //         //check member ship cards

    //         $selected_memberShipCardsUsers = [];



    //         //for report

    //         if (isset($result['price']) && isset($result['tips'])) {



    //         if (!$report->isEmpty()) {

    //             foreach ($report as $value) {

    //                 $price = 0;

    //                 $tip = 0 ;

    //                 if (isset($result['price'][$value->booking_date] ) && isset($result['tips'][$value->booking_date] )) {

    //                     if (!$value->details->isEmpty()) {

    //                         foreach ($value->details as $detail) {

    //                             if (!isset($result['price'][$value->booking_date][$detail->worker_id]) && !isset($result['tips'][$value->booking_date][$detail->worker_id]) ) {

    //                                 continue;

    //                             }

    //                             $price = $detail->price;

    //                             $tip = $detail->tip;

    //                             $result['price'][$value->booking_date][$detail->worker_id] += $price;

    //                             $result['tips'][$value->booking_date][$detail->worker_id] += $tip;



    //                         }

    //                     }

    //                 }

    //             }

    //         } 

    //     } 

    //         //remove for free

    //         if (!empty($result)) {

    //             foreach ($result as $date => $workers_list) {

    //                 foreach ($workers_list as $worker_id => $price) {

    //                     if (isset($memberShipCardsUsers[$date][$worker_id])) {

    //                         $result[$date][$worker_id] -= $memberShipCardsUsers[$date][$worker_id];

    //                     }



    //                     if (isset($discountUsers[$date][$worker_id])) {

    //                         $result[$date][$worker_id] -= $discountUsers[$date][$worker_id];

    //                     }

    //                 }

    //             }

    //         }





    //         $template = (string)view('report.template.tips_report', compact('result', 'firstusers', 'secondusers', 'restusers',

    //          'firstusers_last_total','firstusers_last_total_price', 'firstusers_last_total_tips' , 'secondusers_last_total','secondusers_last_total_price', 'secondusers_last_total_tips' , 

    //          'restusers_last_total','restusers_last_total_price','restusers_last_total_tips', 'vacationsWorkerIds'));



    //         if (isset($request->is_pdf)) {

    //             $pdf = PDF::loadView('report.pdf.tips_report', compact('result', 'firstusers', 'secondusers', 'restusers', 

    //             'firstusers_last_total','firstusers_last_total_price', 'firstusers_last_total_tips' , 'secondusers_last_total','secondusers_last_total_price', 'secondusers_last_total_tips' , 

    //              'restusers_last_total','restusers_last_total_price','restusers_last_total_tips', 'template'))->setPaper('a4', 'landscape');

    //             return $pdf->stream('pdfview.pdf');

    //         }

    //     }



    //     if(empty($all_users))

    //     {    $temp_users = Worker::where('id', '>', 0);

    //         if (get_user_role() != 1) {

    //             $temp_users->where('branch_id', Auth::user()->branch_id);

    //         }



    //         $all_users = $temp_users ->skip(0)->take(33)->get();}



    //     // dd( $all_users as $index=>$value);



    //     return view('report.tips_report', compact('years', 'template', 'selected_year', 'selected_month', 'branches','all_users', 'selected_branch','selected_worker', 'request', 'vacationsWorkerIds'));

    // }

    public function commissions_daily(Request $request)

    {

        $date = $request->get('date');

        $branch_id = $request->get('branch_id');

        $var = $date;

        if (empty($var)) {

            $var = date('d/m/Y');
        }

        $users = [];

        $report = "";

        $users_with_commission = [];

        $temp_branches = Branch::where('id', '>', 0);

        if (get_user_role() != 1) {

            $temp_branches->where('id', Auth::user()->branch_id);
        }

        $branches = $temp_branches->get();

        $selected_branch = $request->get('branch_id');



        if (!empty($date)) {

            $date = convert_date($date);

            $date = date('Y-m-d', strtotime($date));



            $temp_report = Booking::whereRaw('booking_date="' . $date . '"')

                ->with('details');

            if (!empty($request->get('branch_id'))) {

                $temp_report->where('branch_id', $request->get('branch_id'));
            }

            $report = $temp_report->get();

            $users_with_commission = [];

            $temp_users = Worker::where('id', '>', 0);

            if (get_user_role() != 1) {

                $temp_users->where('branch_id', Auth::user()->branch_id);
            }

            if (!empty($branch_id)) {

                $temp_users->where('branch_id', $branch_id);
            }

            $users = $temp_users->get();

            foreach ($users as $user) {

                $users_with_commission[$user->id] = [];
            }

            //for report

            if (!$report->isEmpty()) {

                foreach ($report as $value) {

                    $full_name = $value->full_name;

                    $mobile = $value->mobile;

                    if (!empty($value->details)) {

                        foreach ($value->details as $detail) {

                            if (!empty($detail->commission) && $detail->commission != 0) {

                                array_push($users_with_commission[$detail->worker_id], $detail->commission);
                            }
                        }
                    }
                }
            }

            //get for products

            $temp_BuyProduct = BuyProduct::with('details')->whereRaw('DATE(created_at)="' . $date . '"');

            if (get_user_role() == 1 || $selected_branch) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_BuyProduct->whereHas('created_by_user', function ($query) use ($branch_id) {

                    return $query->where('branch_id', $branch_id);
                });
            }

            $BuyProduct = $temp_BuyProduct->get();

            if (!empty($BuyProduct)) {

                foreach ($BuyProduct as $BuyProduct_item) {

                    //worker commission

                    if (isset($users_with_commission[$BuyProduct_item->worker_id])) {

                        array_push($users_with_commission[$BuyProduct_item->worker_id], $BuyProduct_item->commission);
                    }
                }
            }



            //get for wallet

            $temp_get_wallets = UserWallet::whereRaw('DATE(created_at)="' . $date . '"');

            if (get_user_role() == 1 || $selected_branch) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_get_wallets->whereHas('created_by_user', function ($query) use ($branch_id) {

                    return $query->where('branch_id', $branch_id);
                });
            }

            $get_wallets = $temp_get_wallets->get();

            if (!$get_wallets->isEmpty()) {

                foreach ($get_wallets as $get_wallet) {

                    //worker commission
                    if (isset($users_with_commission[$get_wallet->worker_id])) {
                        $commission = (int)$get_wallet->invoiced_amount * $get_wallet->commission / 100;
                        array_push($users_with_commission[$get_wallet->worker_id], $commission);
                    }
                }
            }
        }

        $template = (string)view('report.template.commission_report', compact('users', 'var', 'users_with_commission'));

        if (isset($request->is_pdf)) {

            $pdf = PDF::loadView('report.pdf.commission_report', compact('users', 'template', 'var', 'users_with_commission'))->setPaper('a4', 'landscape');

            return $pdf->stream('pdfview.pdf');
        }

        return view('report.commission_report', compact('date', 'var', 'template', 'branches', 'selected_branch',  'request', 'users_with_commission'));
    }



    public function commissions(Request $request)

    {

        $branch_id = $request->get('branch_id');

        $years = Booking::select(DB::raw('DISTINCT YEAR(booking_date) as year'))

            ->get();

        $selected_year = $request->get('year');

        $selected_month = $request->get('month');

        $temp_branches = Branch::where('id', '>', 0);

        $users_with_totals = [];

        if (get_user_role() != 1) {

            $temp_branches->where('id', Auth::user()->branch_id);
        }

        $branches = $temp_branches->get();

        $selected_branch = $request->get('branch_id');

        $template = "";

        if (!empty($request->year)) {

            $temp_users = Worker::where('id', '>', 0);

            if (get_user_role() == 1 || $selected_branch) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_users->where('branch_id', $branch_id);
            }

            $users = $temp_users->get();

            $result = [];

            $days = cal_days_in_month(CAL_GREGORIAN, $request->get('month'), $request->get('year'));

            for ($i = 1; $i <= $days; $i++) {

                $month = ($request->get('month') <= 9) ? "0" . $request->get('month') : $request->get('month');

                $day = ($i <= 9) ? "0" . $i : $i;

                $date = $request->get('year') . "-" . $month . "-" . $day;

                $temp = [];

                foreach ($users as $index => $value) {

                    $temp[$value->id] = 0;

                    $users_with_totals[$value->id] = 0;
                }

                $result[$date] = $temp;

                $result[$date]["total"] = 0;
            }

            $temp_report = Booking::whereRaw('YEAR(booking_date)="' . $request->get('year') . '"')

                ->whereRaw('MONTH(booking_date)="' . $request->get('month') . '"')

                ->with('details');

            if (!empty($request->get('branch_id'))) {

                $temp_report->where('branch_id', $request->get('branch_id'));
            }



            $report = $temp_report->get();

            if (!$report->isEmpty()) {

                foreach ($report as $value) {

                    $price = 0;

                    if (isset($result[$value->booking_date])) {

                        if (!$value->details->isEmpty()) {

                            foreach ($value->details as $detail) {
                                if (isset($result[$value->booking_date][$detail->worker_id])) {
                                    $commission = (int)$detail->price * $detail->commission / 100;
                                    $result[$value->booking_date][$detail->worker_id] += $commission;
                                    $users_with_totals[$detail->worker_id] += $commission;
                                    $result[$value->booking_date]["total"] += $commission;
                                }
                            }
                        }
                    }
                }
            }



            //get sales cash and sales visa

            $temp_users_wallets = UserWallet::whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"');

            if (get_user_role() == 1 || $branch_id) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_users_wallets->whereHas('created_by_user', function ($query) use ($branch_id) {

                    return $query->where('branch_id', $branch_id);
                });
            }

            $users_wallets = $temp_users_wallets->get();

            if (!empty($users_wallets)) {

                foreach ($users_wallets as $users_wallet) {

                    $date = date('Y-m-d', strtotime($users_wallet->created_at));

                    //worker commission

                    if (!empty($users_wallet->commission)) {

                        if (isset($result[$date][$users_wallet->worker_id])) {

                            $commission = (int)$users_wallet->invoiced_amount * $users_wallet->commission / 100;

                            $result[$date][$users_wallet->worker_id] += $commission;

                            $users_with_totals[$users_wallet->worker_id] += $commission;

                            $result[$date]["total"] += $commission;
                        }
                    }
                }
            }

            //get for products

            $temp_BuyProduct = BuyProduct::whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"')->with('details');

            if (get_user_role() == 1 || $branch_id) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_BuyProduct->whereHas('created_by_user', function ($query) use ($branch_id) {

                    return $query->where('branch_id', $branch_id);
                });
            }

            $BuyProduct = $temp_BuyProduct->get();

            if (!empty($BuyProduct)) {

                foreach ($BuyProduct as $BuyProduct_item) {

                    $date = date('Y-m-d', strtotime($BuyProduct_item->created_at));

                    //worker commission

                    if (!empty($BuyProduct_item->commission)) {

                        if (isset($result[$date][$BuyProduct_item->worker_id])) {

                            $result[$date][$BuyProduct_item->worker_id] += $BuyProduct_item->commission;

                            $result[$date]["total"] += $BuyProduct_item->commission;

                            $users_with_totals[$BuyProduct_item->worker_id] += $BuyProduct_item->commission;
                        }
                    }
                }
            }

            $firstusers = $temp_users->skip(0)->take(16)->get();

            $secondusers = $temp_users->skip(16)->take(33)->get();

            $restusers = $temp_users->skip(33)->get();



            $template = (string)view('report.template.commission_report', compact('result', 'firstusers', 'secondusers', 'restusers', 'users_with_totals'));



            if (isset($request->is_pdf)) {

                $pdf = PDF::loadView('report.pdf.commission_report', compact('result', 'firstusers', 'secondusers', 'restusers', 'template'))->setPaper('a4', 'landscape');

                return $pdf->stream('pdfview.pdf');
            }
        }

        return view('report.commission_report', compact('years', 'template', 'selected_year', 'selected_month', 'branches', 'selected_branch', 'request'));
    }


    public function commissions_suggestion(Request $request)
    {
        $branch_id = $request->get('branch_id');
        $years = Booking::select(DB::raw('DISTINCT YEAR(booking_date) as year'))->get();

        $selected_year = $request->get('year');
        $selected_month = $request->get('month');
        $temp_branches = Branch::where('id', '>', 0);
        $users_with_totals = [];
        if (get_user_role() != 1) {
            $temp_branches->where('id', Auth::user()->branch_id);
        }

        $branches = $temp_branches->get();
        $selected_branch = $request->get('branch_id');
        $template = "";
        if (!empty($request->year)) {

            $temp_users = Worker::where('id', '>', 0);
            if (get_user_role() == 1 || $selected_branch) {
                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;
                $temp_users->where('branch_id', $branch_id);
            }

            $users = $temp_users->get();
            $result = [];
            $days = cal_days_in_month(CAL_GREGORIAN, $request->get('month'), $request->get('year'));

            for ($i = 1; $i <= $days; $i++) {
                $month = ($request->get('month') <= 9) ? "0" . $request->get('month') : $request->get('month');
                $day = ($i <= 9) ? "0" . $i : $i;
                $date = $request->get('year') . "-" . $month . "-" . $day;
                $temp = [];
                foreach ($users as $index => $value) {
                    $temp[$value->id] = 0;
                    $users_with_totals[$value->id] = 0;
                }
                $result[$date] = $temp;
                $result[$date]["total"] = 0;
            }

            $temp_report = Booking::whereRaw('YEAR(booking_date)="' . $request->get('year') . '"')
                ->whereRaw('MONTH(booking_date)="' . $request->get('month') . '"')
                ->with('details');

            if (!empty($request->get('branch_id'))) {
                $temp_report->where('branch_id', $request->get('branch_id'));
            }

            $report = $temp_report->get();
            if (!$report->isEmpty()) {
                foreach ($report as $value) {
                    $price = 0;
                    if (isset($result[$value->booking_date])) {
                        if (!$value->details->isEmpty()) {
                            foreach ($value->details as $detail) {
                                if (!empty($detail->commission_staff_worker_id) && !empty($detail->commission_staff)) {
                                    $commission = (int)$detail->price * $detail->commission_staff / 100;
                                    $result[$value->booking_date][$detail->commission_staff_worker_id] += $commission;
                                    $users_with_totals[$detail->commission_staff_worker_id] += $commission;
                                    $result[$value->booking_date]["total"] += $commission;
                                }
                            }
                        }
                    }
                }
            }

            $firstusers = $temp_users->skip(0)->take(16)->get();
            $secondusers = $temp_users->skip(16)->take(33)->get();
            $restusers = $temp_users->skip(33)->get();

            $template = (string)view('report.template.commission_suggestion_report', compact('result', 'firstusers', 'secondusers', 'restusers', 'users_with_totals'));

            if (isset($request->is_pdf)) {
                $pdf = PDF::loadView('report.pdf.commission_suggestion_report', compact('result', 'firstusers', 'secondusers', 'restusers', 'template'))->setPaper('a4', 'landscape');
                return $pdf->stream('pdfview.pdf');
            }
        }

        return view('report.commission_suggestion_report', compact('years', 'template', 'selected_year', 'selected_month', 'branches', 'selected_branch', 'request'));
    }


    public function tips(Request $request)

    {

        $branch_id = $request->get('branch_id');



        $years = Booking::select(DB::raw('DISTINCT YEAR(booking_date) as year'))

            ->get();

        $selected_year = $request->get('year');

        $selected_month = $request->get('month');

        $temp_branches = Branch::where('id', '>', 0);

        $users_with_totals = [];

        if (get_user_role() != 1) {

            $temp_branches->where('id', Auth::user()->branch_id);
        }

        $branches = $temp_branches->get();

        $selected_branch = $request->get('branch_id');

        $template = "";

        if (!empty($request->year)) {

            $temp_users = Worker::where('id', '>', 0);

            if (get_user_role() == 1 || $selected_branch) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_users->where('branch_id', $branch_id);
            }

            $users = $temp_users->get();

            $result = [];

            $days = cal_days_in_month(CAL_GREGORIAN, $request->get('month'), $request->get('year'));

            for ($i = 1; $i <= $days; $i++) {

                $month = ($request->get('month') <= 9) ? "0" . $request->get('month') : $request->get('month');

                $day = ($i <= 9) ? "0" . $i : $i;

                $date = $request->get('year') . "-" . $month . "-" . $day;

                $temp = [];

                foreach ($users as $index => $value) {

                    $temp[$value->id] = 0;

                    $users_with_totals[$value->id] = 0;
                }

                $result[$date] = $temp;

                $result[$date]["total"] = 0;
            }

            $temp_report = Booking::whereRaw('YEAR(booking_date)="' . $request->get('year') . '"')

                ->whereRaw('MONTH(booking_date)="' . $request->get('month') . '"')

                ->with('details');

            if (!empty($request->get('branch_id'))) {

                $temp_report->where('branch_id', $request->get('branch_id'));
            }



            $report = $temp_report->get();

            if (!$report->isEmpty()) {

                foreach ($report as $value) {

                    $price = 0;

                    if (isset($result[$value->booking_date])) {

                        if (!$value->details->isEmpty()) {



                            foreach ($value->details as $detail) {

                                //tips

                                if (isset($result[$value->booking_date][$detail->worker_id])) {

                                    $result[$value->booking_date][$detail->worker_id] += $detail->tip;

                                    $users_with_totals[$detail->worker_id] += $detail->tip;

                                    $result[$value->booking_date]["total"] += $detail->tip;
                                }
                            }
                        }
                    }
                }
            }



            //get sales cash and sales visa

            $temp_users_wallets = UserWallet::whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"');

            if (get_user_role() == 1 || $branch_id) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_users_wallets->whereHas('created_by_user', function ($query) use ($branch_id) {

                    return $query->where('branch_id', $branch_id);
                });
            }

            $users_wallets = $temp_users_wallets->get();

            if (!empty($users_wallets)) {

                foreach ($users_wallets as $users_wallet) {

                    $date = date('Y-m-d', strtotime($users_wallet->created_at));

                    //worker tip

                    if (!empty($users_wallet->tip)) {

                        if (isset($result[$date][$users_wallet->worker_id])) {

                            $result[$date][$users_wallet->worker_id] += $users_wallet->tip;

                            $users_with_totals[$users_wallet->worker_id] += $users_wallet->tip;

                            $result[$date]["total"] += $users_wallet->tip;
                        }
                    }
                }
            }

            //get for products

            $temp_BuyProduct = BuyProduct::whereRaw('YEAR(created_at)="' . $request->get('year') . '" and MONTH(created_at)="' . $request->get('month') . '"')->with('details');

            if (get_user_role() == 1 || $branch_id) {

                $branch_id = $selected_branch ? $selected_branch : Auth::user()->branch_id;

                $temp_BuyProduct->whereHas('created_by_user', function ($query) use ($branch_id) {

                    return $query->where('branch_id', $branch_id);
                });
            }

            $BuyProduct = $temp_BuyProduct->get();

            if (!empty($BuyProduct)) {

                foreach ($BuyProduct as $BuyProduct_item) {

                    $date = date('Y-m-d', strtotime($BuyProduct_item->created_at));

                    //worker tip

                    if (!empty($BuyProduct_item->tip)) {

                        if (isset($result[$date][$BuyProduct_item->worker_id])) {

                            $result[$date][$BuyProduct_item->worker_id] += $BuyProduct_item->tip;

                            $result[$date]["total"] += $BuyProduct_item->tip;

                            $users_with_totals[$BuyProduct_item->worker_id] += $BuyProduct_item->tip;
                        }
                    }
                }
            }

            $firstusers = $temp_users->skip(0)->take(16)->get();

            $secondusers = $temp_users->skip(16)->take(33)->get();

            $restusers = $temp_users->skip(33)->get();





            $template = (string)view('report.template.tips_report', compact('result', 'firstusers', 'secondusers', 'restusers', 'users_with_totals', 'request'));



            if (isset($request->is_pdf)) {

                $pdf = PDF::loadView('report.pdf.tips_report', compact('result', 'firstusers', 'secondusers', 'restusers', 'template'))->setPaper('a4', 'landscape');

                return $pdf->stream('pdfview.pdf');
            }
        }



        return view('report.tips_report', compact('years', 'template', 'selected_year', 'selected_month', 'branches', 'selected_branch', 'request', 'request'));
    }
}
