<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class BookingUserService extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "bookings_users_services";
    protected $fillable = [
        'user_id',
        'service_id',
        'service_count'
    ];
    public static function boot()
    {
        parent::boot();

        static::created(function(BookingUserService $row)
        {
            set_log('bookings_users_services','insert',$row->id);
        });
        static::updated(function(BookingUserService $row)
        {
            set_log('bookings_users_services','update',$row->id);
        });
        static::deleted(function(BookingUserService $row)
        {
            set_log('bookings_users_services','delete',$row->id);
        });
    }
}
