<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Branch extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "branches";
    protected $fillable = [
        'name_en',
        'name_ar',
        'city_en',
        'city_ar',
        'address_en',
        'address_ar',
        'longitude',
        'latitude',
        'status',
    ];
    public static function boot()
    {
        parent::boot();

        static::created(function(Branch $row)
        {
            set_log('branch','insert',$row->id);
        });
        static::updated(function(Branch $row)
        {
            set_log('branch','update',$row->id);
        });
        static::deleted(function(Branch $row)
        {
            set_log('branch','delete',$row->id);
        });
    }
    
    public function user_wallets()
    {
        return $this->hasMany(UserWallet::class,'branch_id');
    }

    public function user_used_wallet()
    {
        return $this->hasMany(UserUsedWallet::class,'branch_id');
    }
}
