<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class BuyProductDetail extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "buy_products_details";
    protected $fillable = [
        'buy_product_id',
        'product_id',
        'price',
    ];
    protected $with = "product";
    public static function boot()
    {
        parent::boot();

        static::created(function(BuyProductDetail $row)
        {
            set_log('BuyProductDetail','insert',$row->id);
        });
        static::updated(function(BuyProductDetail $row)
        {
            set_log('BuyProductDetail','update',$row->id);
        });
        static::deleted(function(BuyProductDetail $row)
        {
            set_log('BuyProductDetail','delete',$row->id);
        });
    }
    public function product(){
        return $this->belongsTo(Product::class,'product_id');
    }
}
