<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class Discount extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "discounts";
    protected $fillable = [
        'code',
        'type',
        'amount',
        'start_at',
        'end_at',
        'status',
        'using_type',
        'benefit_numbers',
    ];
    public static function boot()
    {
        parent::boot();

        static::creating(function(Discount $row)
        {
            $row->created_by = Auth::id();
        });

        static::created(function(Discount $row)
        {
            set_log('Discount','insert',$row->id);
        });
        static::updated(function(Discount $row)
        {
            set_log('Discount','update',$row->id);
        });
        static::deleted(function(Discount $row)
        {
            set_log('Discount','delete',$row->id);
        });
    }

    public function created_by_user(){
        return $this->belongsTo(User::class,'created_by');
    }
}
