<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Role extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "roles";
    protected $fillable = [
        'name',
    ];
    public static function boot()
    {
        parent::boot();

        static::created(function(Role $role)
        {
            set_log('role','insert',$role->id);
        });
        static::updated(function(Role $role)
        {
            set_log('role','update',$role->id);
        });
        static::deleted(function(Role $role)
        {
            set_log('role','delete',$role->id);
        });
        static::deleting(function (Role $role)
        {
            PermissionRole::where('role_id',$role->id)->delete();
        });

    }

    public function permissions(){
        return $this->belongsToMany(\App\Models\Permission::class,'permissions_roles')->select([
            'permissions.id',
            'permissions.group',
            'permissions.meta_key'
        ]);
    }
    public function users(){
        return $this->hasMany(User::class,'role_id');
    }

}
