<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBranchesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('branches', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name_en',255)->nullable();
            $table->string('name_ar',255)->nullable();
            $table->string('city_en',255)->nullable();
            $table->string('city_ar',255)->nullable();
            $table->string('address_en',255)->nullable();
            $table->string('address_ar',255)->nullable();
            $table->string('longitude',255)->nullable();
            $table->string('latitude',255)->nullable();
            $table->string('status')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('branches');
    }
}
