<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('services', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name_en',255)->nullable();
            $table->string('name_ar',255)->nullable();
            $table->bigInteger('rooms_no')->nullable();
            $table->bigInteger('free_book')->nullable();
            $table->string('max_time')->nullable();
            $table->string('extra_time')->nullable();
            $table->float('price',10,2)->nullable();
            $table->bigInteger('sort_order')->nullable();
            $table->string('status')->nullable();
            $table->string('top_service')->nullable();
            $table->text('image')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('services');
    }
}
