<?php

use Illuminate\Database\Seeder;
use App\User;

class AddBranchIDsToUserWalletsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $users_wallets = DB::table('users_wallets')->whereNull('branch_id')->get();

        foreach ($users_wallets as $user_wallet)
        {
            if (isset($user_wallet->created_by)) $user = User::find($user_wallet->created_by);
            
            DB::table('users_wallets')->where('id', $user_wallet->id)->update(['branch_id' => $user->branch_id ?? 10]);
        }
        
        return 'Done';
    }
}