<?php

use Illuminate\Database\Seeder;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $array = [
            'User',
            'Role',
            'Hotel',
            'Client',
            'Provider',
            'Guide',
            'Airline',
            'Airport',
            'Service',
            'Hall',
            'Tour',
            'Room',
            'Hotel reservation type',
            'Car',
            'Country',
            'City',
            'Zone',
            'Reservation',
            'Reservation Hotels',
            'Reservation Services',
            'Reservation Tours',
            'Reservation Transfer',
            'Reservation Airline',
            'Reservation Halls',
            'Account',
            'Account Clients',
            'Account Providers',
            'Account Hotels',
            'Operations',
            'Operations Transfer',
            'Operations Tours',
            'Reports',
            'Email Template',
            'WhatsApp Template'
        ];
        //for permissions
        foreach ($array as $group=>$name){
            $items = [
                'create',
                'edit',
                'delete',
                'view'
            ];
            foreach ($items as $item){
                DB::table('permissions')->insert(
                    [
                        'group'=>$name,
                        'meta_key'=>$item,
                        'created_at'=>date('y-m-d h:i:s'),
                        'updated_at'=>date('y-m-d h:i:s')
                    ]
                );
            }
        }
    }
}
