<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;
use Symfony\Component\Mailer\Mailer;
use Symfony\Component\Mailer\Transport;
use Symfony\Component\Mime\Email;

use Illuminate\Http\Request;


class LoginController extends Controller
{
    public function index()
    {

        return view('login/index');
    }

    public function doLogin(Request $request)
    {
	
		
        $message = 'Error in email / password.';
        $validated = Validator::make($request->all(), [
            'email' => 'required|email:rfc',
            'password' => 'required'
        ]);
        if ($validated->fails()) {
            $error = $validated->errors()->first();
            return response()->json([
                'success' => false,
                'errors' => $error
            ]);
        } else {
            $remember = ($request->get('remember')) ? true : false;
            $email = $request->get('email');
            $password = $request->get('password');
            if (Auth::attempt(['email' => $email, 'password' => $password], $remember)) {
                Auth::user();
                return response()->json([
                    'success' => true,
                ]);
            }
            return response()->json([
                'success' => false,
                'errors' => $message
            ]);
        }
		

    }

    public function checkLogin(Request $request)
    {
        $main_id = Auth::user()->id;
        $name = $request->get('name');
        $name = decryptTo($name);
        $response = [
            'success' => false,
            'message' => 'An error occurs !'
        ];
        switch ($name) {
            case 'e_commerce';
                $response = $this->doCommerceLogin($main_id);
                $response['back_url'] = "p-login";
                break;
            case 'classification';
                $response = $this->doClassificationLogin($main_id);
                $response['back_url'] = "en/p-login";
                break;
        }
        return response()->json($response);
    }

    public function logout(Request $request)
    {
        Auth::logout();
        return redirect('login');
    }

 /*   public function reset_password(Request $request){
        $validated = Validator::make($request->all(), [
            'email' => 'required|email:rfc',
        ]);
        if ($validated->fails()) {
            $error = $validated->errors()->first();
            return response()->json([
                'success' => false,
                'message' => $error
            ]);
        }else{
            //check if email exist
            $check = User::where('email',$request->get('email'))->first();
            if(!empty($check)){
                return response()->json([
                    'success' => true,
                    'message' => "Reset link was sent to your email."
                ]);
            }else{
                return response()->json([
                    'success' => false,
                    'message' => "Email is not exist in our system."
                ]);
            }
        }
    }*/

public function reset_password(Request $request)
{
    $validated = Validator::make($request->all(), [
        'email' => 'required|email:rfc',
    ]);

    if ($validated->fails()) {
        $error = $validated->errors()->first();
        return response()->json([
            'success' => false,
            'message' => $error
        ]);
    } else {
        // Check if email exists
        $check = User::where('email', $request->get('email'))->first();
        if (!empty($check)) {
        
          

				// Create a password reset URL
				$resetUrl = url('reset-passwordprocess/' . base64_encode($request->get('email') . '|' . time()));
				
				Log::info('Attempting to send password reset email', [
					'email' => $request->get('email'),
					'reset_url' => $resetUrl,
                    'ip' => request()->ip()
				]);
				
				try {
					$transport = Transport::fromDsn('smtp://2920e7c5462d83:15b77de3c517f4@sandbox.smtp.mailtrap.io:2525');
					$mailer = new Mailer($transport);
					
					$email = (new Email())
						->from('TechnoSystems@ResetPassword.com')
						->to($request->get('email')) 
						->subject('reset password for Techno Systems') 
						->html('<p>Hello,</p><p>Please click the following link to reset your password:</p><p><a href="' . $resetUrl . '">' . $resetUrl . '</a></p>');

					$mailer->send($email);
					
					Log::info('Password reset email sent successfully', [
						'email' => $request->get('email'),
						'reset_url' => $resetUrl,
                        'ip' => request()->ip()
					]);
				} catch (\Exception $e) {
					Log::error('Failed to send password reset email', [
						'email' => $request->get('email'),
						'error' => $e->getMessage(),
						'file' => $e->getFile(),
						'line' => $e->getLine(),
                        'ip' => request()->ip()
					]);
					
					return response()->json([
						'success' => false,
						'message' => 'Failed to send reset email. Please try again later.' .$e->getMessage()
					]);
				}
				
            return response()->json([
                'success' => true,
                'message' => "Reset link was sent to your email."
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => "Email is not exist in our system."
            ]);
        }
    }
}

/*
public function reset_password(Request $request)
{
    $validated = Validator::make($request->all(), [
        'email' => 'required|email:rfc',
    ]);

    if ($validated->fails()) {
        $error = $validated->errors()->first();
        return response()->json([
            'success' => false,
            'message' => $error
        ]);
    } else {
        // Check if email exists
        $check = User::where('email', $request->get('email'))->first();
        if (!empty($check)) {
         

            return response()->json([
                'success' => true,
                'message' => "Reset link was sent to your email."
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => "Email is not exist in our system."
            ]);
        }
    }
}
*/


    public function change_password(Request $request){

        $message_result = [];
        $valid = [
            'password'=>'required|confirmed'
        ];
        $validator = Validator::make($request->all(), $valid);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }else{
            $user_password = Auth::user()->getAuthPassword();
            if(!Hash::check($request->current_password,$user_password)){
                return response()->json(['success' => false, 'message' => "Current password not valid"]);
            }
            $user = User::find(Auth::id());
            $user->password = Hash::make($request->get('password'));
            $user->save();
            return response()->json(['success' => true, 'message' => "Password was changed successfully"]);
        }
    }
    
    // Show forgot password form
    public function forgotPassword()
    {
        Log::info('Forgot password page accessed', [
            'ip' => request()->ip(),
            'user_agent' => request()->userAgent()
        ]);
        
        return view('auth.passwords.email');
    }

}
