<!DOCTYPE html>
<!--[if IE 8]>
<html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]>
<html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en">
<!--<![endif]-->
<!-- BEGIN HEAD -->
<head>
    <style>
        .reset-password .logo {
            margin: 0px auto 20px auto !important;
            padding: 15px;
            text-align: center;
        }
    </style>
    <meta charset="utf-8"/>
    <title>Reset Password - Royal Team Care</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <meta http-equiv="Content-type" content="text/html; charset=utf-8">
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet"
          type="text/css"/>
    <link href="{{url('assets/global/plugins/font-awesome/css/font-awesome.min.css')}}" rel="stylesheet"
          type="text/css"/>
    <link href="{{url('assets/global/plugins/simple-line-icons/simple-line-icons.min.css')}}" rel="stylesheet"
          type="text/css"/>
    <link href="{{ url('assets/global/plugins/bootstrap/css/bootstrap.min.css')  }}" type="text/css" rel="stylesheet"/>
    <!-- END GLOBAL MANDATORY STYLES -->
    <!-- BEGIN PAGE LEVEL STYLES -->
    <link href="{{url('assets/admin/pages/css/login-soft.css')}}" rel="stylesheet" type="text/css"/>
    <!-- END PAGE LEVEL SCRIPTS -->
    <!-- BEGIN THEME STYLES -->
    <link href="{{ url('assets/global/css/components.css')  }}" id="style_components" rel="stylesheet" type="text/css"/>
    <link href="{{ url('assets/global/css/plugins.css')  }}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('assets/admin/layout2/css/layout.css')  }}" rel="stylesheet" type="text/css"/>
    <link id="style_color" href="{{ url('assets/admin/layout2/css/themes/default.css')  }}" rel="stylesheet"
          type="text/css"/>
    <link href="{{ url('') }}/assets/global/plugins/toastr/toastr.min.css" rel="stylesheet" type="text/css"/>
    <link href="{{url('assets/admin/layout2/css/custom.css')}}" rel="stylesheet" type="text/css"/>
    <!-- END THEME STYLES -->
    <link rel="icon"  type="image/x-icon" href="https://demo1.allin1uae.com/assets/images/1621929665app.png"/>

    <style>
        .reset-btn{
            background-color: #c2943c !important;
        }
        .reset-btn:hover{
            background-color: #c59f54 !important;
        }
        .company{
            color: #FFFFFF;
            text-decoration: underline;
            font-weight: bold;
        }
    </style>

    @include('partials.js_css.styles')
</head>
<!-- END HEAD -->
<!-- BEGIN BODY -->
<body class="reset-password">
<!-- BEGIN LOGO -->
<div class="logo">
    <a href="{{ url('login') }}">
        <img style="width: 150px;" src="{{ url('assets/img/bg-logo.png')  }}" alt=""/>
    </a>
</div>
<!-- END LOGO -->
<!-- BEGIN SIDEBAR TOGGLER BUTTON -->
<div class="menu-toggler sidebar-toggler">
</div>
<!-- END SIDEBAR TOGGLER BUTTON -->
<!-- BEGIN RESET PASSWORD -->
<div class="content">
    <!-- BEGIN RESET PASSWORD FORM -->
    <form id="reset_password_form" action="{{ route('password.update') }}" method="post">
        <input type="hidden" value="{{ csrf_token() }}" name="_token">
        <input type="hidden" name="token" value="{{ $token }}">
        
        <div class="alert alert-danger" id="form-error" style="display: none"></div>
        <h3 class="form-title">Reset Your Password</h3>
        
        <div class="form-group">
            <!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
            <label class="control-label visible-ie8 visible-ie9">Email</label>
            <div class="input-icon">
                <i class="fa fa-envelope"></i>
                <input required class="form-control placeholder-no-fix" type="email" autocomplete="off"
                       placeholder="Email" name="email" value="{{ $email ?? old('email') }}" readonly/>
            </div>
        </div>
        
        <div class="form-group">
            <label class="control-label visible-ie8 visible-ie9">New Password</label>
            <div class="input-icon">
                <i class="fa fa-lock"></i>
                <input required class="form-control placeholder-no-fix" type="password" autocomplete="off"
                       placeholder="New Password" name="password"/>
            </div>
        </div>
        
        <div class="form-group">
            <label class="control-label visible-ie8 visible-ie9">Confirm Password</label>
            <div class="input-icon">
                <i class="fa fa-check-circle"></i>
                <input required class="form-control placeholder-no-fix" type="password" autocomplete="off"
                       placeholder="Confirm Password" name="password_confirmation"/>
            </div>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn blue pull-right reset-btn">
                Reset Password <i class="m-icon-swapright m-icon-white"></i>
            </button>
            <br>
            <br>
            <div class="copyright">
                © Copyrights <a class="company" href="https://etechnocode.com/" target="_blank" >{{ company() }}</a> {{ date('Y') }}. All rights reserved.
            </div>
        </div>
    </form>
</div>

<!-- END RESET PASSWORD -->
<!-- BEGIN COPYRIGHT -->
<!-- END COPYRIGHT -->
<!-- BEGIN JAVASCRIPTS(Load javascripts at bottom, this will reduce page load time) -->
<!-- BEGIN CORE PLUGINS -->
<!--[if lt IE 9]>
<script src="{{ url('assets/global/plugins/respond.min.js') }}"></script>
<script src="{{ url('assets/global/plugins/excanvas.min.js') }}"></script>
<![endif]-->
<script src="{{ url('assets/global/plugins/jquery.min.js') }}" type="text/javascript"></script>
<script src="{{ url('assets/global/plugins/jquery-migrate.min.js') }}" type="text/javascript"></script>
<script src="{{ url('assets/global/plugins/bootstrap/js/bootstrap.min.js') }}" type="text/javascript"></script>
<script src="{{ url('assets/global/plugins/jquery.blockui.min.js') }}" type="text/javascript"></script>
<script src="{{ url('assets/global/plugins/uniform/jquery.uniform.min.js') }}" type="text/javascript"></script>
<script src="{{ url('assets/global/plugins/jquery.cokie.min.js') }}" type="text/javascript"></script>
<!-- END CORE PLUGINS -->
<!-- BEGIN PAGE LEVEL PLUGINS -->
<script src="{{ url('assets/global/plugins/jquery-validation/js/jquery.validate.min.js')  }}"
        type="text/javascript"></script>
<script src="{{ url('assets/global/plugins/backstretch/jquery.backstretch.min.js')  }}" type="text/javascript"></script>
<script type="text/javascript" src="{{ url('assets/global/plugins/select2/select2.min.js')  }}"></script>
<!-- END PAGE LEVEL PLUGINS -->
<!-- BEGIN PAGE LEVEL SCRIPTS -->
<script src="{{ url('assets/global/scripts/metronic.js')  }}" type="text/javascript"></script>
<script src="{{ url('assets/admin/layout2/scripts/layout.js') }}" type="text/javascript"></script>
<script src="{{ url('assets/admin/layout2/scripts/demo.js') }}" type="text/javascript"></script>
<script src="{{ url('assets/admin/pages/scripts/login-soft.js') }}" type="text/javascript"></script>
<script src="{{ url('') }}/assets/global/plugins/toastr/toastr.min.js" type="text/javascript"></script>
<!-- END PAGE LEVEL SCRIPTS -->
<script>
    jQuery(document).ready(function () {
        var toastar_options = toastr.options = {
            "closeButton": false,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-top-center",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "8000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        };

        Metronic.init(); // init metronic core components
        Layout.init(); // init current layout
        Login.init();
        Demo.init();
        // init background slide images
        $.backstretch([
                "{{ url('assets/admin/pages/media/bg/1.jpg')  }}",
                "{{ url('assets/admin/pages/media/bg/2.jpg')  }}",
                "{{ url('assets/admin/pages/media/bg/3.jpg')  }}",
                "{{ url('assets/admin/pages/media/bg/4.jpg')}}"
            ], {
                fade: 1000,
                duration: 8000
            }
        );
        
        //reset password form
        $(document).on("submit","#reset_password_form",function(e){
            var self = $(this);
            e.preventDefault();
            $("#form-error").hide();
            
            var password = self.find("input[name=password]").val();
            var password_confirmation = self.find("input[name=password_confirmation]").val();
            
            // Basic validation
            if (password !== password_confirmation) {
                $("#form-error").show().html("Passwords do not match!");
                return false;
            }
            
            if (password.length < 8) {
                $("#form-error").show().html("Password must be at least 8 characters long!");
                return false;
            }
            
            self.find("button[type=submit]").attr("disabled","disabled");
            $.ajax({
                "url": "{{ route('password.update') }}",
                "type": "POST",
                "dataType": "JSON",
                "data": {
                    'password': password,
                    'password_confirmation': password_confirmation,
                    'token': self.find("input[name=token]").val(),
                    'email': self.find("input[name=email]").val(),
                    '_token': self.find("input[name=_token]").val()
                },
                "success": function (data) {
                    if(data.success){
                        toastr.success(data.message, toastar_options);
                        // Redirect to login after successful reset
                        setTimeout(function() {
                            window.location = '{{ route("login") }}';
                        }, 2000);
                    }else{
                        self.find("button[type=submit]").removeAttr("disabled");
                        if(data.message){
                            $("#form-error").show().html(data.message);
                        } else if(data.errors){
                            $("#form-error").show().html(data.errors);
                        }
                    }
                },
                "error": function (xhr) {
                    self.find("button[type=submit]").removeAttr("disabled");
                    if(xhr.responseJSON && xhr.responseJSON.message){
                        $("#form-error").show().html(xhr.responseJSON.message);
                    } else {
                        $("#form-error").show().html("An error occurred. Please try again.");
                    }
                }
            });
        });
    });
</script>
<!-- END JAVASCRIPTS -->
</body>
<!-- END BODY -->
</html>
