@extends('layout')

@push('styles')
    @include('booking.styles')
@endpush

@section('content')
    <div class="portlet box blue-hoki">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-plus"></i>{{ __('s.Bookings List') }}
            </div>

            @if (can('user.create'))
                <a style="margin: 5px 0" href="" data-toggle="modal" data-target="#create_booking"
                    class="btn btn-success pull-right">
                    {{ __('s.Create New Booking') }}
                </a>
            @endif
        </div>

        <div class="portlet-body">
            <table id="booking_table" class="table table-bordered table-stripped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{ __('s.Branch') }}</th>
                        <th>{{ __('s.Services') }}</th>
                        <th>{{ __('s.full_name') }}</th>
                        <th>{{ __('s.mobile') }}</th>
                        <th>{{ __('s.payment_type') }}</th>
                        <th>{{ __('Booking Date') }}</th> <!-- New column -->
                        <th>{{ __('s.created_by') }}</th>
                        <th>{{ __('s.actions') }}</th>
                    </tr>
                </thead>

                <tbody>
                </tbody>
            </table>
        </div>
    </div>

    @include('booking.modal')
@endsection

@push('scripts')
    <script>    
        var workers = {!! json_encode($workers) !!};
    </script>

    @include('booking.script')
@endpush
