
@extends('layout')
@push('styles')
@include('booking.styles')
@endpush
@section('content')

    <div class="portlet box blue-hoki">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-plus"></i>Booking List For Tips
            </div>
            @if(can('user.create'))
                <a style="margin: 5px 0" href="" data-toggle="modal" data-target="#create_booking" class="btn btn-success pull-right">
                    {{ __('s.Create New Booking With Tips') }}
                </a>
            @endif
        </div>
        <div class="portlet-body">
            <table id="booking_table3" class="table table-bordered table-stripped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Branch </th>
                    <th>Date&Time</th>
                    <th>Worker Name</th>
                    <th>Tips</th>
                    <th>Created By</th> <!-- Added 'Created By' column -->
                    <th>Actions</th>
                     </tr>
                </thead>
                <tbody>
                    @if(!$booking_tips_list->isEmpty())
                        @foreach($booking_tips_list as $item)
                        @if(\Illuminate\Support\Facades\Auth::user()->role_id == 1 || (\Illuminate\Support\Facades\Auth::user()->role_id == 2 && $item->branch_id == \Illuminate\Support\Facades\Auth::user()->branch_id))

                            <tr>
                                <td>{{ $item->id }}</td>
                                <td>
                                    @if(!empty($item->branch))
                                        {{ $item->branch->name_en }}
                                    @endif
                                </td>
                                <td>
                                    {{ $item->details->first()->_date ?? '' }}
                                </td>
                                <td>
                                    {{ \App\Models\Worker::where('id', $item->details->first()->worker_id)->value('name') }}
                                </td>
                                <td>
                                    {{ $item->details->first()->tip ?? '' }}
                                </td>
                                <td>
                                    {{-- Display the 'created_by' information --}}
                                    {{ isset($item->user) ? $item->user->first_name . ' ' . $item->user->last_name : 'Not Found' }}
                                </td>
                                <td>
                                    {{-- Add your 'actions' column content here --}}
                                    <?php
                                        $template = "<a data-id='" . $item->id . "' href='" . set_route('booking.invoice.print') . "?id=" . $item->id . "' target='_blank'  class='btn btn-primary btn-sm print-row'><i class='fa fa-print'></i></a>";
                                       
                                        if(\Illuminate\Support\Facades\Auth::user()->role_id == 1) {
                                            $template .= "<a data-id='" . $item->id . "' href='" . set_route('booking.delete', ['id' => $item->id]) . "' class='btn btn-danger btn-xs delete-row'><i class='fa fa-times'></i></a>";
                                                                                   }
                                        echo $template;
                                    ?>

                                        @if(\Illuminate\Support\Facades\Auth::user()->role_id ==1)

                                        <button class="btn btn-info btn-xs edit-row" data-id="{{ $item->id }}"><i class='fa fa-pencil'></i> Edit</button>
                                            <form class="edit-form hidden" id="edit-form-{{ $item->id }}" data-id="{{ $item->id }}">
                                                <input type="date" name="edited_date" value="{{ $item->details->first()->_date ?? '' }}">
                                                <button type="submit" class="btn btn-success btn-xs save-row"><i class='fa fa-save'></i> Save</button>
                                            </form>
                                        @endif         
                                </td>
                                
                            </tr>
                        @endif    
                        @endforeach
                    @endif
                </tbody>
            </table>
        </div>
    </div>
    @include('booking.tips_modal')
@endsection



@push('scripts')
    @include('booking.script')
    
@endpush

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.edit-row').click(function(e) {
                e.preventDefault();
                var itemId = $(this).data('id');
                $('#edit-form-' + itemId).removeClass('hidden');
            });

            $('.edit-form').submit(function(e) {
                e.preventDefault();
                var itemId = $(this).data('id');
                var editedDate = $(this).find('input[name="edited_date"]').val();
                console.log('kll;l');

                $.ajax({
                    method: 'POST',
                    url: '{{ route('booking.update.date', ['locale' => 'en']) }}', // Replace 'en' with the appropriate locale value
                    data: {
                        id: itemId,
                        edited_date: editedDate,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        console.log('Date updated successfully');
                        $('#edit-form-' + itemId).addClass('hidden');
                        // You might update the displayed date here on success
                    },
                    error: function(err) {
                        console.error('Error updating date:', err);
                    }
                });


            });
        });
    </script>