<div id="parent_content_services">
    <h4 class="text-center">{{ 'Booking Details' }}</h4>
    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <label>{{ 'Select Booking Details' }}</label>
                <select multiple class="form-control service-select select" name="service_id[]">
                    @foreach(\App\Http\Controllers\Booking\BookingController::get_all_workers() as $worker)
                        @if(isset($worker) && !empty($worker))
                            <option value="{{ $worker->id }}">{{ $worker->name }}</option>
                        @endif
                    @endforeach
                </select>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <label for="booking_date">Booking Date</label>
                <input type="date" class="form-control" id="booking_date" name="booking_date">
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label for="tips">Tips (Between 0 and 200)</label>
                <input type="number" class="form-control" id="tips" name="tips" min="0" max="200">
            </div>
        </div>
        
        @php
        // Set session data here
        session(['booking_date' => request('booking_date'), 'tips' => request('tips')]);

        @endphp
    </div>
    <ul class="list-inline pull-right">
            <li>
            <button type="button" class="btn btn-success next-step next-Tips_booking">Continue to next step</button>
        </li>
    </ul>

</div>

