<script type="text/javascript">
    $(document).ready(function() {
        $(".date-only").datetimepicker({
            format: 'D/M/Y'
        });

        var table = $("table").dataTable({
            processing: true,
            serverSide: true,
            "order": [
                [0, "desc"]
            ],
            ajax: "{{ set_route('buy.product') }}",
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'products',
                    name: 'products'
                },
                {
                    data: 'total',
                    name: 'total'
                },
                {
                    data: 'created_by',
                    name: 'created_by'
                },
                {
                    data: 'sales_employee',
                    name: 'sales_employee'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
            ]
        });

        $("#accountForm").validate({
            rules: {
                amount: {
                    number: true
                }
            }
        });
        $(document).on("submit", "#accountForm", function(e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "{{ set_route('buy.product.store') }}",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function(data) {
                    if (data.success) {
                        location.reload();
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function(e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //edit discount
        $(document).on("click", ".edit-discount", function(e) {
            var self = $(this);
            $.ajax({
                "url": "{{ set_route('discount.edit') }}?id=" + self.data("id"),
                "type": "GET",
                "dataType": "JSON",
                "data": {},
                "success": function(data) {
                    var row = data.row;
                    $("#editModal .form-control").each(function() {
                        var field_name = $(this).attr("name");
                        if (row[field_name] != undefined) {
                            if (field_name != "password" && field_name != "logo" &&
                                field_name != "image")
                                $(this).val(row[field_name])
                        }
                    });
                    if (row.using_type == "single") {
                        $("#editModal").find(".content-benefit-numbers").hide();
                    } else {
                        $("#editModal").find(".content-benefit-numbers").show();
                    }
                },
                "error": function() {

                }
            });
        });
        $(document).on("submit", "#editForm", function(e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "{{ set_route('discount.update') }}",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function(data) {
                    if (data.success) {
                        $("#editModal").modal('hide');
                        table.fnDraw();
                        toastr.success(data.message, toastar_options);
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function(e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //using_type
        $(document).on("change", "select[name=using_type]", function(e) {
            var self = $(this);
            if (self.val() == "single") {
                $(".content-benefit-numbers").hide();
            } else {
                $(".content-benefit-numbers").show();
            }
        });
        //change employee
        $(document).on("change", "select[name=worker_id]", function(e) {
            var self = $(this);
            if (self.val() !== "") {
                $("#content-commission").show();
            } else {
                $("#content-commission").hide();
            }
        });
    });
</script>
