<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>OTP Request Notification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #c2943c;
            color: white;
            padding: 20px;
            text-align: center;
            border-radius: 5px 5px 0 0;
        }
        .content {
            background-color: #f9f9f9;
            padding: 20px;
            border: 1px solid #ddd;
            border-top: none;
            border-radius: 0 0 5px 5px;
        }
        .otp-box {
            background-color: #fff;
            border: 2px solid #c2943c;
            border-radius: 5px;
            padding: 15px;
            margin: 20px 0;
            text-align: center;
        }
        .otp-code {
            font-size: 32px;
            font-weight: bold;
            color: #c2943c;
            letter-spacing: 5px;
        }
        .user-info {
            background-color: #e7f3ff;
            border-left: 4px solid #2196F3;
            padding: 15px;
            margin: 20px 0;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            color: #666;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>🔐 OTP Request Notification</h1>
        <p>Royal Team Care System</p>
    </div>
    
    <div class="content">
        <h2>New OTP Request Received</h2>
        
        <div class="user-info">
            <h3>📧 User Information:</h3>
            <p><strong>Email:</strong> {{ $userEmail }}</p>
            <p><strong>IP Address:</strong> {{ $ip }}</p>
            <p><strong>Time:</strong> {{ date('Y-m-d H:i:s') }}</p>
        </div>
        
        <div class="otp-box">
            <h3>🔢 OTP Code for User</h3>
            <div class="otp-code">{{ $otp }}</div>
            <p><strong>Expires in:</strong> 5 minutes</p>
        </div>
        
        <div style="background-color: #fff3cd; border: 1px solid #ffeaa7; padding: 15px; border-radius: 5px; margin: 20px 0;">
            <h3>⚠️ Action Required:</h3>
            <p>Please provide this OTP code to the user: <strong>{{ $userEmail }}</strong></p>
            <p>The user is waiting to complete their login process.</p>
        </div>
        
        <div style="background-color: #d4edda; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px; margin: 20px 0;">
            <h3>📋 Summary:</h3>
            <p><strong>Email:</strong> {{ $userEmail }}</p>
            <p><strong>Requested OTP:</strong> {{ $otp }}</p>
            <p><strong>Status:</strong> Pending user verification</p>
        </div>
    </div>
    
    <div class="footer">
        <p>This is an automated notification from Royal Team Care System</p>
        <p>Please do not reply to this email</p>
        <p>Generated on: {{ date('Y-m-d H:i:s') }}</p>
    </div>
</body>
</html>
