<script type="text/javascript">
    $(document).ready(function () {
        $(".date-only").datetimepicker({format: 'D/M/Y'});

        var table = $("table").dataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ set_route('package') }}",
            columns: [
                {data: 'id', name: 'id'},
                {data: 'name_en', name: 'name_en'},
                {data: 'paid_services', name: 'paid_services'},
                {data: 'free_service', name: 'free_service'},
                {data: 'status', name: 'status'},
                {data: 'created_by', name: 'created_by'},
                {data: 'action', name: 'action',
                    orderable: false, searchable: false},
            ]
        });

        $("#accountForm").validate({
            rules:{
                amount: {
                    number: true
                }
            }
        });
        $(document).on("submit", "#accountForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "{{ set_route('package.store') }}",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        location.reload();
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //edit Package
        $(document).on("click", ".edit-package", function (e) {
            var self = $(this);
            $.ajax({
                "url": "{{ set_route('package.edit') }}?id="+self.data("id"),
                "type": "GET",
                "dataType": "JSON",
                "data": {},
                "success": function (data) {
                    var row = data.row;
                    $("#editModal .form-control").each(function () {
                        var field_name = $(this).attr("name");
                        if(row[field_name] != undefined){
                            if(field_name!="password" && field_name !="logo" && field_name !="image") {
                                $(this).val(row[field_name]);
                            }
                            if(field_name=="free_service"){
                                $(this).val(row[field_name]).trigger('change');
                            }
                        }
                    });

                    $("#editModal .service-select").select2('destroy');
                    $("#editModal .service-select option").each(function () {
                        for(var i = 0;i<row.services_id.length;i++){
                            if($(this).val()==row.services_id[i]){
                                $(this).attr("selected","selected");
                            }
                        }
                    });
                    $("#editModal .service-select").select2();
                },
                "error": function () {

                }
            });
        });
        $(document).on("submit", "#editForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "{{ set_route('package.update') }}",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        $("#editModal").modal('hide');
                        table.fnDraw();
                        toastr.success(data.message, toastar_options);
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });

    });
</script>