<?php

use Illuminate\Support\Facades\Route;



Route::group(['prefix' => '{locale}', 'where' => ['locale' => '[a-zA-Z]{2}']], function () {

    Route::group(['middleware' => ['setlocale','auth']], function () {

        Route::group(['prefix'=>'member-ship'],function(){

            Route::get('/','Customer\MemberShipController@index')->name('membership');

            Route::post('/store','Customer\MemberShipController@store')->name('membership.store');

            Route::get('/edit','Customer\MemberShipController@edit')->name('membership.edit');

            Route::post('/update','Customer\MemberShipController@update')->name('membership.update');

            Route::get('/{id}/delete','Customer\MemberShipController@destroy')->name('membership.delete');

        });



        Route::group(['prefix'=>'discount'],function(){

            Route::get('/','Customer\DiscountController@index')->name('discount');

            Route::post('/store','Customer\DiscountController@store')->name('discount.store');

            Route::get('/edit','Customer\DiscountController@edit')->name('discount.edit');

            Route::post('/update','Customer\DiscountController@update')->name('discount.update');

            Route::get('/{id}/delete','Customer\DiscountController@destroy')->name('discount.delete');

        });





        Route::group(['prefix'=>'wallet'],function(){

            Route::get('/','Customer\WalletController@index')->name('wallet');

            Route::post('/store','Customer\WalletController@store')->name('wallet.store');

            Route::get('/edit','Customer\WalletController@edit')->name('wallet.edit');

            Route::post('/update','Customer\WalletController@update')->name('wallet.update');

            Route::get('/{id}/delete','Customer\WalletController@destroy')->name('wallet.delete');

            Route::post('/save-users','Customer\WalletController@save_users')->name('wallet.users');

            Route::get('/show-users','Customer\WalletController@show_users')->name('wallet.users.show');

            Route::get('/print-user-wallet','Customer\WalletController@print_user_wallet')->name('wallet.users.print');

        });





        Route::group(['prefix'=>'package'],function(){

            Route::get('/','Customer\PackageController@index')->name('package');

            Route::post('/store','Customer\PackageController@store')->name('package.store');

            Route::get('/edit','Customer\PackageController@edit')->name('package.edit');

            Route::post('/update','Customer\PackageController@update')->name('package.update');

            Route::get('/{id}/delete','Customer\PackageController@destroy')->name('package.delete');

            // Route::post('/save-users','Customer\PackageController@save_users')->name('package.users');

        });

    });



    });





