<?php
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => '{locale}', 'where' => ['locale' => '[a-zA-Z]{2}']], function () {
    Route::group(['middleware' => ['setlocale','auth','admin.super']], function () {
        Route::group(['prefix'=>'product'],function(){
            Route::get('/','Product\ProductController@index')->name('product');
            Route::post('/store','Product\ProductController@store')->name('product.store');
            Route::get('/edit','Product\ProductController@edit')->name('product.edit');
            Route::post('/update','Product\ProductController@update')->name('product.update');
            Route::get('/{id}/delete','Product\ProductController@destroy')->name('product.delete');
        });
    });
});