<?php
use Illuminate\Support\Facades\Route;
// for super admin
Route::group(['middleware' => ['auth','admin.super']], function () {
    //role
    Route::group(['prefix'=>'role'],function(){
        Route::get('/','User\RoleController@index');
        //create
        Route::get('/create','User\RoleController@create');
        Route::post('/store','User\RoleController@store');
        //update
        Route::get('{id}/edit','User\RoleController@edit');
        Route::post('{id}/update','User\RoleController@update');
        //delete
        Route::get('{id}/delete','User\RoleController@destroy');
    });
});