<?php
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => '{locale}', 'where' => ['locale' => '[a-zA-Z]{2}']], function () {
    Route::group(['middleware' => ['setlocale','auth','admin.super']], function () {
        Route::group(['prefix'=>'shift'],function(){
            Route::get('/','Shift\ShiftController@index')->name('shift');
            Route::post('/store','Shift\ShiftController@store')->name('shift.store');
            Route::get('/edit','Shift\ShiftController@edit')->name('shift.edit');
            Route::post('/update','Shift\ShiftController@update')->name('shift.update');
            Route::get('/{id}/delete','Shift\ShiftController@destroy')->name('shift.delete');
        });
    });
});