<script type="text/javascript">
    $(document).ready(function () {
        $(".time-only").datetimepicker({format: 'HH:mm'});

        var table = $("table").dataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(set_route('service')); ?>",
            columns: [
                {data: 'id', name: 'id'},
                {data: 'name_en', name: 'name_en'},
                {data: 'rooms_no', name: 'rooms_no'},
                {data: 'free_book', name: 'free_book'},
                {data: 'price', name: 'price'},
                {data: 'sort_order', name: 'sort_order'},
                {data: 'top_service', name: 'top_service'},
                {data: 'status', name: 'status'},
                {data: 'image', name: 'image'},
                {data: 'action', name: 'action',
                    orderable: false, searchable: false},
            ]
        });

        $("#accountForm").validate({
            rules:{
                price: {
                    number: true
                }
            }
        });
        $(document).on("submit", "#accountForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('service.store')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        location.reload();
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //edit service
        $(document).on("click", ".edit-service", function (e) {
            var self = $(this);
            $.ajax({
                "url": "<?php echo e(set_route('service.edit')); ?>?id="+self.data("id"),
                "type": "GET",
                "dataType": "JSON",
                "data": {},
                "success": function (data) {
                    var row = data.row;
                    $("#editModal .form-control").each(function () {
                        var field_name = $(this).attr("name");
                        if(row[field_name] != undefined){
                            if(field_name !="image") {
                                $(this).val(row[field_name])
                            }
                            if(field_name==="image"){
                                $("#editModal .content-image").html('<img width="150px" src="<?php echo e(\Illuminate\Support\Facades\Storage::url('')); ?>'+row[field_name]+'">');
                            }
                            if(field_name==="has_commission" && row[field_name]==1){
                                $("#editModal input[name=has_commission]").prop('checked',true);
                            }
                        }
                    });
                },
                "error": function () {

                }
            });
        });
        $(document).on("submit", "#editForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('service.update')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        $("#editModal").modal('hide');
                        table.fnDraw();
                        toastr.success(data.message, toastar_options);
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });

    });
</script><?php /**PATH /home/menscare/public_html/test/resources/views/service/script.blade.php ENDPATH**/ ?>