
<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
            <a class="dashboard-stat dashboard-stat-v2 blue" href="<?php echo e(set_route('account')); ?>">
                <div class="visual">
                    <i class="fa fa-comments"></i>
                </div>
                <div class="details">
                    <div class="number">
                        <span data-counter="counterup" data-value="<?php echo e($users); ?>">
                            <?php echo e($users); ?>

                        </span>
                    </div>
                    <div class="desc"> <?php echo e(__('s.accounts')); ?></div>
                </div>
            </a>
        </div>


        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
            <a class="dashboard-stat dashboard-stat-v2 green" href="<?php echo e(set_route('booking')); ?>">
                <div class="visual">
                    <i class="fa fa-shopping-cart"></i>
                </div>
                <div class="details">
                    <div class="number">
                        <span data-counter="counterup" data-value="<?php echo e($bookings); ?>"><?php echo e($bookings); ?></span>
                    </div>
                    <div class="desc"> <?php echo e(__('s.bookings')); ?></div>
                </div>
            </a>
        </div>

        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
            <a class="dashboard-stat dashboard-stat-v2 green" href="<?php echo e(set_route('booking_tips')); ?>">
                <div class="visual">
                    <i class="fa fa-shopping-cart"></i>
                </div>
                <div class="details">
                    <div class="number">
                        <span data-counter="counterup" data-value="<?php echo e($bookings); ?>"><?php echo e($bookings); ?></span>
                    </div>
                    <div class="desc"> <?php echo e(__('s.bookings')); ?></div>
                </div>
            </a>
        </div>

        <?php if(\Illuminate\Support\Facades\Auth::user()->role_id==1 || \Illuminate\Support\Facades\Auth::user()->role_id==4): ?>
            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <a class="dashboard-stat dashboard-stat-v2 red" href="<?php echo e(set_route('worker')); ?>">
                    <div class="visual">
                        <i class="fa fa-bar-chart-o"></i>
                    </div>
                    <div class="details">
                        <div class="number">
                        <span data-counter="counterup" data-value="<?php echo e($workers); ?>">
                            <?php echo e($workers); ?>

                        </span>
                        </div>
                        <div class="desc"> <?php echo e(__('s.employees')); ?> </div>
                    </div>
                </a>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <a class="dashboard-stat dashboard-stat-v2 purple" href="<?php echo e(set_route('service')); ?>">
                    <div class="visual">
                        <i class="fa fa-globe"></i>
                    </div>
                    <div class="details">
                        <div class="number">
                            <span data-counter="counterup" data-value="<?php echo e($services); ?>"><?php echo e($services); ?></span></div>
                        <div class="desc"> <?php echo e(__('s.services')); ?> </div>
                    </div>
                </a>
            </div>
        <?php endif; ?>
    </div>

    <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
            <div class="col-md-12">
                <div class="portlet box blue-hoki">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-plus"></i><?php echo e(__('s.Bookings List')); ?>

                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-responsive">
                            <table class="table table-bordered" id="booking_table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('s.branch')); ?></th>
                                        <th><?php echo e(__('s.services')); ?></th>
                                        <th><?php echo e(__('s.full_name')); ?></th>
                                        <th>Date&Time</th>
                                        <th><?php echo e(__('s.mobile')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(!$bookings_list->isEmpty()): ?>
                                        <?php
                                            $count = 0;
                                            $i=0;
                                        ?>
                                        <?php $__currentLoopData = $bookings_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                if ($i == 10) {
                                                    break;
                                                }
                                                if (empty($item->details->first()->service_id)) {
                                                    continue;
                                                }

                                                if ($count++ == 10) {
                                                    continue;
                                                }
                                                $i++;
                                            ?>
                                            <tr>
                                                <td><?php echo e($item->id); ?></td>
                                                <td>
                                                    <?php if(!empty($item->branch)): ?>
                                                        <?php echo e($item->branch->name_en); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(!$item->details->isEmpty()): ?>
                                                        <?php $__currentLoopData = $item->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(!empty($detail->service)): ?>
                                                                <?php echo e($detail->service->name_en); ?><br>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php echo e($item->full_name); ?>

                                                </td>
                                                 <td>
                                                    <?php echo e($item->details->first()->_date); ?>

                                                </td>
                                                <td>
                                                    +971<?php echo e($item->mobile); ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="portlet box blue-hoki">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-plus"></i>Bookings List For Tips
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-responsive">
                            <table class="table table-bordered" id="booking_table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('s.branch')); ?></th>
                                        <th>Date&Time</th>
                                        <th>Worker Name</th>
                                        <th>Tips</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(!$bookings_list->isEmpty()): ?>
                                        <?php
                                            $count = 0;
                                            $i=0;
                                        ?>
                                        <?php $__currentLoopData = $bookings_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                if ($i == 10) {
                                                    break;
                                                }
                                                if (!empty($item->details->first()->service_id)) {
                                                    continue;
                                                }

                                                if ($count++ == 10) {
                                                    continue;
                                                }
                                                $i++;
                                            ?>
                                            <tr>
                                                <td><?php echo e($item->id); ?></td>
                                                <td>
                                                    <?php if(!empty($item->branch)): ?>
                                                        <?php echo e($item->branch->name_en); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                <?php echo e($item->details->first()->_date); ?>

                                                </td>
                                                <td>
                                                     <?php echo e(\App\Models\Worker::where('id', $item->details->first()->worker_id)->value('name')); ?>


                                                </td>
                                                <td>
                                                    <?php echo e($item->details->first()->tip); ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>


        </div>

        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
            <div class="portlet box blue-hoki">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-plus"></i><?php echo e(__('s.Accounts List')); ?>

                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="accounts_table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo e(__('s.first_name')); ?></th>
                                    <th><?php echo e(__('s.first_name')); ?></th>
                                    <th><?php echo e(__('s.wallet')); ?></th>
                                    <th><?php echo e(__('s.phone')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(!$users_list->isEmpty()): ?>
                                    <?php
                                        $count = 0;
                                    ?>
                                    <?php $__currentLoopData = $users_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            if ($count++ == 10) {
                                                continue;
                                            }
                                        ?>
                                        <tr>
                                            <td><?php echo e($item->id); ?></td>
                                            <td>
                                                <?php echo e($item->first_name); ?>

                                            </td>
                                            <td>
                                                <?php echo e($item->last_name); ?>

                                            </td>
                                            <td>
                                                <?php echo e(get_num_format($item->wallet)); ?>

                                            </td>
                                            <td>
                                                <?php echo e($item->country_code); ?><?php echo e($item->phone); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            // Your script code here
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/etechnoc/public_html/meenscare/resources/views/dashboard/index.blade.php ENDPATH**/ ?>