<div class="form-group row">
    <label class="col-sm-2 col-form-label text-black"><?php echo e(__('s.products')); ?></label>
    <div class="col-sm-10">
        <select class="form-control select" name="product_id[]" multiple required>
            <?php if(!empty($products)): ?>
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($product->id); ?>"><?php echo e($product->name_en); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </select>
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-2 col-form-label text-black"><?php echo e(__('s.payment_type')); ?></label>
    <div class="col-sm-10">
        <select class="form-control select" name="payment_type" required>
            <option value=""><?php echo e(__('s.select_type')); ?></option>
            <?php $__currentLoopData = \App\Http\Controllers\Booking\BookingController::get_payment_types(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $payment_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    if (in_array($index, ['sales_cash_cp', 'sales_visa_cp', 'free', 'wallet', 'service_cash', 'service_visa'])) {
                        continue;
                    }
                ?>
                <option value="<?php echo e($index); ?>"><?php echo e($payment_type); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-2 col-form-label text-black"><?php echo e(__('s.discount')); ?></label>
    <div class="col-sm-10">
        <select class="form-control select" name="discount">
            <option value=""><?php echo e(__('s.select_discount')); ?></option>
            <?php for($i = 1; $i <= 15; $i++): ?>
                <option value="<?php echo e($i); ?>"><?php echo e($i); ?>%</option>
            <?php endfor; ?>
        </select>
    </div>
</div>
<div class="form-group row">
    <label class="col-sm-2 col-form-label text-black"><?php echo e(__('s.sales_employee')); ?></label>
    <div class="col-sm-10">
        <select class="form-control select required" required name="sales_worker_id">
            <option value=""><?php echo e(__('s.select_employee')); ?></option>
            <?php if(!empty($workers)): ?>
                <?php $__currentLoopData = $workers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $worker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($worker->id); ?>"><?php echo e($worker->name); ?> ( <?php echo e($worker->phone); ?> )</option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </select>
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-2 col-form-label text-black"><?php echo e(__('s.employee')); ?></label>
    <div class="col-sm-10">
        <select class="form-control select" name="worker_id">
            <option value=""><?php echo e(__('s.select_employee')); ?></option>
            <?php if(!empty($workers)): ?>
                <?php $__currentLoopData = $workers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $worker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($worker->id); ?>"><?php echo e($worker->name); ?> ( <?php echo e($worker->phone); ?> )</option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </select>
    </div>
</div>

<div class="form-group row" id="content-commission" style="display: none">
    <label class="col-sm-2 col-form-label text-black"><?php echo e(__('s.commission')); ?></label>
    <div class="col-sm-10">
        <select class="form-control select" name="commission">
            
            <?php for($i = 1; $i <= 100; $i++): ?>
                <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
            <?php endfor; ?>
        </select>
    </div>
</div>
<?php /**PATH /home/royalteamcare/public_html/royaltest/resources/views/buy_product/form.blade.php ENDPATH**/ ?>