<script type="text/javascript">
    $(document).ready(function () {
        var table = $("table").dataTable({
            processing: true,
            serverSide: true,
            "order": [[ 0, "desc" ]],
            ajax: "<?php echo e(set_route('account')); ?>",
            columns: [
                {data: 'id', name: 'id'},
                {data: 'first_name', name: 'first_name'},
                {data: 'last_name', name: 'last_name'},
                {data: 'branch', name: 'branch'},
                {data: 'role', name: 'role'},
                {data: 'wallet', name: 'wallet'},
                {data: 'email', name: 'email'},
                {data: 'phone', name: 'phone'},
                {data: 'action', name: 'action',
                    orderable: false, searchable: false},
            ]
        });

        $("#accountForm").validate();
        $(document).on("submit","#accountForm",function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('account.store')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if(data.success){
                        location.reload();
                    }else {
                        toastr.error(data.message,toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //edit user
        $(document).on("click", ".edit-user", function (e) {
            var self = $(this);
            $("#editModal .content-password .text-danger").remove();
            $("#editModal .content-password").find("input").removeAttr("required");
            $("#editModal .content-password input").val('');

            $.ajax({
                "url": "<?php echo e(set_route('account.edit')); ?>?id="+self.data("id"),
                "type": "GET",
                "dataType": "JSON",
                "data": {},
                "success": function (data) {
                    var row = data.row;
                    if(row.role_id==3){
                        $("#editModal .content-password").hide();
                    }else{
                        $("#editModal .content-password").show();
                    }
                    if(row.role_id==2){
                        $("#editModal .content-branch").show();
                        $("#editModal select[name=branch_id]").attr("required","required");
                    }else{
                        $("#editModal .content-branch").hide();
                        $("#editModal select[name=branch_id]").removeAttr("required","required");
                    }
                    $("#editModal .form-control").each(function () {
                        var field_name = $(this).attr("name");
                        if(row[field_name] != undefined){
                            if(field_name!="password" && field_name !="logo" && field_name !="image")
                                $(this).val(row[field_name])
                        }
                    });
                },
                "error": function () {

                }
            });
        });
        $(document).on("submit", "#editForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('account.update')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        $("#editModal").modal('hide');
                        table.fnDraw();
                        toastr.success(data.message, toastar_options);
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //on change role
        $(document).on("change","select[name=role_id]",function (e) {
            var self = $(this);
            if(self.val()==2){
                $(".content-branch").show();
            }else{
                $(".content-branch").hide();
            }
            if(self.val()==3){
                $(".content-password").hide();
            }else{
                $(".content-password").show();
            }
        });
        $(document).on("change","select[name=role_id]",function (e) {
            var self = $(this);
            if(self.val()==3){
                $(".email-required-star").hide();
                $("input[name=email]").removeAttr("required");
            }else{
                $(".email-required-star").show();
                $("input[name=email]").attr("required","required");
            }
        });


    });
</script><?php /**PATH /home/technosystems/public_html/resources/views/account/script.blade.php ENDPATH**/ ?>