<script type="text/javascript">
    $(document).ready(function () {
        $(".time-only").datetimepicker({format: 'HH:mm'});

        var table = $("table").dataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(set_route('shift')); ?>",
            columns: [
                {data: 'id', name: 'id'},
                {data: 'name', name: 'name'},
                {data: 'start_time', name: 'start_time'},
                {data: 'end_time', name: 'end_time'},
                {data: 'break_start', name: 'break_start'},
                {data: 'break_end', name: 'break_end'},
                {data: 'status', name: 'status'},
                {data: 'action', name: 'action',
                    orderable: false, searchable: false},
            ]
        });

        $("#accountForm").validate();
        $(document).on("submit", "#accountForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('shift.store')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        location.reload();
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //edit shift
        $(document).on("click", ".edit-shift", function (e) {
            var self = $(this);
            $.ajax({
                "url": "<?php echo e(set_route('shift.edit')); ?>?id="+self.data("id"),
                "type": "GET",
                "dataType": "JSON",
                "data": {},
                "success": function (data) {
                    var row = data.row;
                    $("#editModal .form-control").each(function () {
                        var field_name = $(this).attr("name");
                        if(row[field_name] != undefined){
                            if(field_name!="password" && field_name !="logo" && field_name !="image")
                                $(this).val(row[field_name])
                        }
                    });
                },
                "error": function () {

                }
            });
        });
        $(document).on("submit", "#editForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('shift.update')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        $("#editModal").modal('hide');
                        table.fnDraw();
                        toastr.success(data.message, toastar_options);
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });

    });
</script><?php /**PATH C:\xampp\htdocs\TechnoSystem\resources\views/shift/script.blade.php ENDPATH**/ ?>