<!DOCTYPE html>details
<html>

<head>
    <meta charset="utf-8" />
    <title>Invoice</title>

    <style>
        @page  {
            margin: 15px;
            /* size: 80mm 20cm; */
        }

        /* @font-face {
            font-family: 'ANK';
            font-weight: normal;
            font-style: normal;
            font-variant: normal;
            src: url("<?php echo e(public_path('assets/fonts/ank.ttf')); ?>") format('truetype');
        } */

        /* @font-face {
            font-family: 'Merchant Copy';
            font-weight: normal;
            font-style: normal;
            font-variant: normal;
            src: url("<?php echo e(public_path('assets/fonts/MerchantCopy.ttf')); ?>") format('truetype');
        } */
        /* @font-face {
            font-family: 'Futura T Extra Bold';
            font-weight: bold;
            src: url("<?php echo e(public_path('assets/fonts/futura_t_extra_bold.ttf')); ?>") format('truetype');
        } */

        .invoice-box {
            max-width: 100%;
            margin: auto;
            font-size: 14px;
            font-weight: bolder;
            line-height: 20px;
            /* font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; */
            /* font-family: 'DejaVu Sans'; */
            /* font-family: 'Futura T Extra Bold'; */
            font-family: 'Courier-Bold', sans-serif;
            /* font-family: 'ANK', sans-serif; */
            /* font-family: 'Merchant Copy', sans-serif; */
            color: #555;
        }

        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: left;
        }

        .invoice-box table td {
            padding: 2px;
            vertical-align: top;
        }

        .invoice-box table tr.heading td {
            background: #eee;
            border-bottom: 1px solid #ddd;
            font-weight: bold;
        }

        .invoice-box table tr.details td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.item td {
            border-bottom: 1px solid #eee;
        }

        .invoice-box table tr.item.last td {
            border-bottom: none;
        }

        .invoice-box table tr.total td:nth-child(2) {
            border-top: 2px solid #eee;
            font-weight: bold;
        }

        @media  only screen and (max-width: 600px) {
            .invoice-box table tr.top table td {
                width: 100%;
                display: block;
                text-align: center;
            }

            .invoice-box table tr.information table td {
                width: 100%;
                display: block;
                text-align: center;
            }
        }

        /** RTL **/
        .invoice-box.rtl {
            direction: rtl;
        }

        .invoice-box.rtl table {
            text-align: right;
        }

        .invoice-box.rtl table tr td:nth-child(2) {
            text-align: left;
        }

        .itemsTable {
            padding-top: 20px;
            padding-bottom: 20px;
        }
    </style>
</head>

<body>
    <div class="invoice-box">
        <table cellpadding="0" cellspacing="0">
            <tr class="top">
                <td colspan="2">
                    <table>
                        <tr>
                            <td align="center" class="title">
                                <img src="<?php echo e(public_path('assets/img/bg-logo.png')); ?>" style="width: 80px;height: auto" />
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
           <tr>
                    <td colspan="2" align="center">Royal Team</td>
                </tr>
                <tr>
                    <td colspan="2" align="center">02 000 0000, 02 000 0000, 02 000 0000</td>
                </tr>
                <tr>
                    <td colspan="2" align="center">UNAITED ARAB EMIRATS</td>
                </tr>
                <tr>
                    <td colspan="2" align="center">ABUDHABI, 000000</td>
                </tr>
                <tr>
                    <td colspan="2" align="center">Techno</td>
                </tr>
                <tr>
                    <td colspan="2" align="center">TRN 100000000000000</td>
                </tr>
            <tr>
                <td colspan="2">
                    <table class="itemsTable">
                        <tr>
                            <td>Receipt:</td>
                            <td><?php echo e($result->id); ?></td>
                        </tr>
                        <tr>
                            <td>Date:</td>
                            <td><?php echo e(date('d-m-Y')); ?></td>
                        </tr>
                        <tr>
                            <td>Served By:</td>
                            <td><?php echo e($result->user->first_name . ' ' . $result->user->last_name); ?></td>
                        </tr>
                        <?php if(!empty($result->payment_type)): ?>
                            <tr>
                                <td>Payment Method:</td>
                                <td>
                                    <?php echo e(\App\Http\Controllers\Booking\BookingController::get_payment_types($result->payment_type)); ?>

                                </td>
                            </tr>
                        <?php endif; ?>
                        <tr>
                            <td>Customer:</td>
                            <td><?php echo e($result->full_name); ?></td>
                        </tr>
                        <tr>
                            <td></td>
                            <td><?php echo e($result->mobile); ?></td>
                        </tr>
                        <tr>
                            <td></td>
                            <td><?php echo e($result->email); ?></td>
                        </tr>
                        <?php if(!empty($result->wallet)): ?>
                            <tr>
                                <td>Wallet</td>
                                <td><?php echo e($result->wallet->code); ?></td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </td>
            </tr>

            <tr>
                <td colspan="2">
                    <table>
                        <tr class="heading">
                        <?php if(!empty($result->details->first()->service)): ?>{
                            <td>Service</td>}
                        <?php endif; ?>
                            <td>Date and Time</td>
                            <?php if(!empty($result->details->first()->price)): ?>
                            
                            <td>Price</td>
                            <?php endif; ?>
                            <?php if(!empty($result->details->first()->tip)): ?>
                            <td>Tips</td>
                            <?php endif; ?>
                        </tr>

                        <?php
                            $service_price = 0;
                        ?>
                        <?php if(!$result->details->isEmpty()): ?>
                            <?php $__currentLoopData = $result->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="item">
                                <?php if(!empty($detail->service) && isset($detail->service->name_en)): ?>
                                    <td><?php echo e($detail->service->name_en); ?></td>
                                <?php endif; ?>
                                    <td><?php echo e($detail->_date . ' ' . $detail->from_time . ' - ' . $detail->to_time); ?></td>
                                    <?php if($detail->is_free == 1): ?>
                                        <td>Free</td>
                                    <?php else: ?>
                                        <?php if(!empty($detail->price)): ?>
                                        <td>AED <?php echo e(number_format($detail->price, 2, '.', '')); ?></td>                                        
                                        <?php endif; ?>                                    <?php endif; ?>
                                    <?php if(!empty($detail->tip) && isset($detail->tip)): ?>
                                    <td><?php echo e($detail->tip); ?></td>
                                    <?php endif; ?>
                                    
                                </tr>
                                <?php
                                    if ($detail->is_free != 1) {
                                        $service_price += $detail->price;
                                    }
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $discount_amount = 0;
                                $card_amount = 0;
                            ?>
                            <?php if(!empty($result->discount_code)): ?>
                                <tr class="heading">
                                    <td colspan="2">Discount Code</td>
                                    <td>Amount</td>
                                </tr>
                                <tr class="details">
                                    <td colspan="2"><?php echo e($result->discount_code->code); ?></td>
                                    <td>
                                        <?php if($result->discount_code->type != 'fixed'): ?>
                                            <?php
                                                $discount_amount = ($service_price * $result->discount_code->amount) / 100;
                                            ?>
                                            AED
                                            <?php echo e(get_num_format(($service_price * $result->discount_code->amount) / 100)); ?>

                                        <?php else: ?>
                                            <?php
                                                $discount_amount = $result->discount_code->amount;
                                            ?>
                                            AED <?php echo e(get_num_format($result->discount_code->amount)); ?>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endif; ?>

                            <?php if(!empty($result->card)): ?>
                                <tr class="heading">
                                    <td colspan="2">Member Ship Card</td>
                                    <td>Amount</td>
                                </tr>
                                <tr class="details">
                                    <td colspan="2"><?php echo e($result->card->code); ?></td>
                                    <td>
                                        <?php
                                            $card_amount = ($service_price * $result->card->amount) / 100;
                                        ?>
                                        <?php echo e(number_format($result->card->amount)); ?>%
                                    </td>
                                </tr>
                            <?php endif; ?>
                            <?php
                                $total = $service_price - $discount_amount - $card_amount;
                            ?>
                            <?php if($total > 0): ?>
                                <tr>
                                    <td>VAT:</td>
                                    <td colspan="2">AED <?php echo e(number_format($total * 0.05, 2, '.', '')); ?></td>
                                </tr>
                                <tr>
                                    <td>Subtotal:</td>
                                    <td colspan="2">AED <?php echo e(number_format($total - $total * 0.05, 2, '.', '')); ?></td>
                                </tr>
                            <?php endif; ?>
                            <tr class="total">
                                <td>Total:</td>
                                <td colspan="2">AED <?php echo e(number_format($total, 2, '.', '')); ?></td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </td>
            </tr>
        </table>
    </div>
</body>

</html>
<?php /**PATH /home/royalteamcare/public_html/royaltest/resources/views/booking/invoice.blade.php ENDPATH**/ ?>