<script type="text/javascript">
    $(document).ready(function () {
        $(".date-only").datetimepicker({format: 'D/M/Y'});
        var table = $("table").dataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(set_route('wallet')); ?>",
            columns: [
                {data: 'id', name: 'id'},
                {data: 'code', name: 'code'},
                {data: 'users', name: 'users'},
                {data: 'amount', name: 'amount'},
                {data: 'invoiced_amount', name: 'invoiced_amount'},
                {data: 'used', name: 'used'},
                {data: 'start_at', name: 'start_at'},
                {data: 'end_at', name: 'end_at'},
                {data: 'status', name: 'status'},
                {data: 'created_by', name: 'created_by'},
                {
                    data: 'action', name: 'action',
                    orderable: false, searchable: false
                },
            ]
        });
        $("#accountForm").validate({
            rules: {
                amount: {
                    number: true
                }
            }
        });
        $(document).on("submit", "#accountForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('wallet.store')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        location.reload();
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //edit wallet
        $(document).on("click", ".edit-wallet", function (e) {
            var self = $(this);
            $.ajax({
                "url": "<?php echo e(set_route('wallet.edit')); ?>?id=" + self.data("id"),
                "type": "GET",
                "dataType": "JSON",
                "data": {},
                "success": function (data) {
                    var row = data.row;
                    $("#editModal .form-control").each(function () {
                        var field_name = $(this).attr("name");
                        if (row[field_name] != undefined) {
                            if (field_name != "password" && field_name != "logo" && field_name != "image")
                                $(this).val(row[field_name])
                        }
                    });
                },
                "error": function () {

                }
            });
        });
        $(document).on("submit", "#editForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('wallet.update')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        $("#editModal").modal('hide');
                        table.fnDraw();
                        toastr.success(data.message, toastar_options);
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //show-users
        $(document).on("click", ".show-users", function (e) {
            var self = $(this);
            var id = self.data("id");
            var wallet_value = self.data("wallet-value");
            var wallet_name = self.data('wallet-name');
            $("#userModal").find("input[name=wallet_id]").val(id);
            $("#userModal").find(".title").text(wallet_name);
            $("#userModal").find(".wallet_value").val(wallet_value);

        });
        $("#userModalForm").validate();
        $(document).on("submit", "#userModalForm", function (e) {
            var self = $(this);
            e.preventDefault();
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            var wallet_id = self.find("input[name=wallet_id]").val();
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('wallet.users')); ?>?wallet_id=" + wallet_id,
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        $("#userModal").modal('hide');
                        table.fnDraw();
                        toastr.success(data.message, toastar_options);
                        self.find("select").val('').trigger('change');
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //show-wallet-users
        $(document).on("click", ".show-wallet-users", function (e) {
            var self = $(this);
            var code = self.data("code");
            $("#showWalletUserModal .title").html(code);
            $("#showWalletUserModal .modal-body").html('<img src="<?php echo e(url('assets/img/loading.gif')); ?>" style="width: 150px;display: block;margin: auto">');
            $.ajax({
                "url": "<?php echo e(set_route('wallet.users.show')); ?>"+"?wallet_id=" + self.data("id"),
                "type": "GET",
                "dataType": "JSON",
                "data": {},
                "success": function (data) {
                    $("#showWalletUserModal .modal-body").html(data.view);
                },
                "error": function () {

                }
            });
        });

        //change employee
        $(document).on("change","select[name=worker_id]",function (e) {
            var self = $(this);
            let wallet_value = $("#userModal").find("input[name='wallet_value']").val();
            $("#content-commission option").addClass("hide");
            console.log(wallet_value);
            console.log($("#content-commission option[data-value='"+wallet_value+"']"));
            $("#content-commission option[data-value='"+wallet_value+"']").removeClass("hide");
            if(self.val()!==""){
                $("#content-commission").show();
            }else{
                $("#content-commission").hide();
            }
        });
    });
</script>
<?php /**PATH /home/technosystems/public_html/dev/resources/views/wallet/script.blade.php ENDPATH**/ ?>