    <!DOCTYPE html>
    <html>

    <head>
        <meta charset="utf-8" />
        <title>Invoice</title>

        <style>
            @page  {
                margin: 15px;
                /* size: 80mm 20cm; */
            }

            /* @font-face {
                font-family: 'ANK';
                font-weight: normal;
                font-style: normal;
                font-variant: normal;
                src: url("<?php echo e(public_path('assets/fonts/ank.ttf')); ?>") format('truetype');
            } */

            /* @font-face {
                font-family: 'Merchant Copy';
                font-weight: normal;
                font-style: normal;
                font-variant: normal;
                src: url("<?php echo e(public_path('assets/fonts/MerchantCopy.ttf')); ?>") format('truetype');
            } */
            /* @font-face {
                font-family: 'Futura T Extra Bold';
                font-weight: bold;
                src: url("<?php echo e(public_path('assets/fonts/futura_t_extra_bold.ttf')); ?>") format('truetype');
            } */

            .invoice-box {
                max-width: 100%;
                margin: auto;
                font-size: 14px;
                font-weight: bolder;
                line-height: 20px;
                /* font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; */
                /* font-family: 'DejaVu Sans'; */
                /* font-family: 'Futura T Extra Bold'; */
                font-family: 'Courier-Bold', sans-serif;
                /* font-family: 'ANK', sans-serif; */
                /* font-family: 'Merchant Copy', sans-serif; */
                color: #555;
            }

            .invoice-box table {
                width: 100%;
                line-height: inherit;
                text-align: left;
            }

            .invoice-box table td {
                padding: 2px;
                vertical-align: top;
            }

            .invoice-box table tr.heading td {
                background: #eee;
                border-bottom: 1px solid #ddd;
                font-weight: bold;
            }

            .invoice-box table tr.details td {
                padding-bottom: 20px;
            }

            .invoice-box table tr.item td {
                border-bottom: 1px solid #eee;
            }

            .invoice-box table tr.item.last td {
                border-bottom: none;
            }

            .invoice-box table tr.total td:nth-child(2) {
                border-top: 2px solid #eee;
                font-weight: bold;
            }

            @media  only screen and (max-width: 600px) {
                .invoice-box table tr.top table td {
                    width: 100%;
                    display: block;
                    text-align: center;
                }

                .invoice-box table tr.information table td {
                    width: 100%;
                    display: block;
                    text-align: center;
                }
            }

            /** RTL **/
            .invoice-box.rtl {
                direction: rtl;
            }

            .invoice-box.rtl table {
                text-align: right;
            }

            .invoice-box.rtl table tr td:nth-child(2) {
                text-align: left;
            }

            .itemsTable {
                padding-top: 20px;
                padding-bottom: 20px;
            }

        </style>
    </head>

    <body>
        <div class="invoice-box">
            <table cellpadding="0" cellspacing="0">
                <tr class="top">
                    <td colspan="2">
                        <table>
                            <tr>
                                <td class="title" align="center">
                                    <img src="<?php echo e(public_path('assets/img/bg-logo.png')); ?>"
                                        style="width: 80px;height: auto" />
                                </td>

                                
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" align="center">Royal Team</td>
                </tr>
                <tr>
                    <td colspan="2" align="center">02 000 0000, 02 000 0000, 02 000 0000</td>
                </tr>
                <tr>
                    <td colspan="2" align="center">UNAITED ARAB EMIRATS</td>
                </tr>
                <tr>
                    <td colspan="2" align="center">ABUDHABI, 000000</td>
                </tr>
                <tr>
                    <td colspan="2" align="center">Techno</td>
                </tr>
                <tr>
                    <td colspan="2" align="center">TRN 100000000000000</td>
                </tr>
                <tr>
                    <td colspan="2">
                        <table class="itemsTable">
                            <tr>
                                <td>Wallet:</td>
                                <td><?php echo e($user_wallet->id); ?></td>
                            </tr>
                            <tr>
                                <td>Date:</td>
                                <td><?php echo e(my_date($user_wallet->created_at)); ?></td>
                            </tr>
                            <tr>
                                <td>Customer:</td>
                                <td><?php echo e($user->first_name . ' ' . $user->last_name); ?></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td><?php echo e('+971' . $user->phone); ?></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td><?php echo e($user->email); ?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr class="heading">
                    <td colspan="2">Wallet</td>
                </tr>

                <tr>
                    <td>VAT: </td>
                    <td><?php echo e(get_currency() . get_num_format($user_wallet->invoiced_amount*0.05)); ?></td>
                </tr>

                <tr>
                    <td>Subtotal: </td>
                    <td><?php echo e(get_currency() . get_num_format($user_wallet->invoiced_amount - $user_wallet->invoiced_amount*0.05)); ?></td>
                </tr>
                <tr class="details">
                    <td>Total:</td>
                    <td><?php echo e(get_currency() . get_num_format($user_wallet->invoiced_amount)); ?></td>
                </tr>

            </table>
        </div>
    </body>

    </html>
<?php /**PATH /home/royalteamcare/public_html/royaltest/resources/views/wallet/invoice.blade.php ENDPATH**/ ?>