<script type="text/javascript">
    $(document).ready(function () {
        $(".time-only").datetimepicker({format: 'HH:mm'});

        var table = $("table").dataTable({
            processing: true,
            serverSide: true,
            "order": [[ 0, "desc" ]],
            ajax: "<?php echo e(set_route('product')); ?>",
            columns: [
                {data: 'id', name: 'id'},
                {data: 'name_en', name: 'name_en'},
                {data: 'price', name: 'price'},
                {data: 'status', name: 'status'},
                {data: 'image', name: 'image'},
                {data: 'action', name: 'action',
                    orderable: false, searchable: false},
            ]
        });

        $("#accountForm").validate({
            rules:{
                price: {
                    number: true
                }
            }
        });
        $(document).on("submit", "#accountForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('product.store')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        location.reload();
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });
        //edit product
        $(document).on("click", ".edit-product", function (e) {
            var self = $(this);
            $.ajax({
                "url": "<?php echo e(set_route('product.edit')); ?>?id="+self.data("id"),
                "type": "GET",
                "dataType": "JSON",
                "data": {},
                "success": function (data) {
                    var row = data.row;
                    $("#editModal .form-control").each(function () {
                        var field_name = $(this).attr("name");
                        if(row[field_name] != undefined){
                            if(field_name !="image") {
                                $(this).val(row[field_name])
                            }
                            if(field_name==="image"){
                                $("#editModal .content-image").html('<img width="150px" src="<?php echo e(\Illuminate\Support\Facades\Storage::url('')); ?>'+row[field_name]+'">');
                            }
                        }
                    });
                },
                "error": function () {

                }
            });
        });
        $(document).on("submit", "#editForm", function (e) {
            e.preventDefault();
            var self = $(this);
            // Get form
            var form = self[0];
            // FormData object
            var data = new FormData(form);
            load_btn(self.find('.save'));
            $.ajax({
                type: "POST",
                enctype: 'multipart/form-data',
                url: "<?php echo e(set_route('product.update')); ?>",
                data: data,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 800000,
                success: function (data) {
                    if (data.success) {
                        $("#editModal").modal('hide');
                        table.fnDraw();
                        toastr.success(data.message, toastar_options);
                    } else {
                        toastr.error(data.message, toastar_options);
                    }
                    remove_btn(self.find('.save'));
                },
                error: function (e) {
                    remove_btn(self.find('.save'));
                }
            });
        });

    });
</script>
<script>
    ClassicEditor
        .create( document.querySelector( '#editor' ) )
        .then( editor => {
        console.log( editor );
    } )
    .catch( error => {
        console.error( error );
    } );
    ClassicEditor
        .create( document.querySelector( '#editor1' ) )
        .then( editor => {
        console.log( editor );
    } )
    .catch( error => {
        console.error( error );
    } );
</script><?php /**PATH /home/technosystems/public_html/resources/views/product/script.blade.php ENDPATH**/ ?>