<!DOCTYPE html>
<!--[if IE 8]>
<html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]>
<html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en">
<!--<![endif]-->
<!-- BEGIN HEAD -->
<head>
    <style>
        .login .logo {
    margin: 0px auto 20px auto !important;
    padding: 15px;
    text-align: center;
}
    </style>
    <meta charset="utf-8"/>
    <title><?php echo e($systemSettings->website_title); ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <meta http-equiv="Content-type" content="text/html; charset=utf-8">
    <meta content="<?php echo e($systemSettings->website_description); ?>" name="description"/>
    <meta content="<?php echo e($systemSettings->author); ?>" name="author"/>
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet"
          type="text/css"/>
    <link href="<?php echo e(url('assets/global/plugins/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet"
          type="text/css"/>
    <link href="<?php echo e(url('assets/global/plugins/simple-line-icons/simple-line-icons.min.css')); ?>" rel="stylesheet"
          type="text/css"/>
    <link href="<?php echo e(url('assets/global/plugins/bootstrap/css/bootstrap.min.css')); ?>" type="text/css" rel="stylesheet"/>
    <!-- END GLOBAL MANDATORY STYLES -->
    <!-- BEGIN PAGE LEVEL STYLES -->
    <link href="<?php echo e(url('assets/admin/pages/css/login-soft.css')); ?>" rel="stylesheet" type="text/css"/>
    <!-- END PAGE LEVEL SCRIPTS -->
    <!-- BEGIN THEME STYLES -->
    <link href="<?php echo e(url('assets/global/css/components.css')); ?>" id="style_components" rel="stylesheet" type="text/css"/>
    <link href="<?php echo e(url('assets/global/css/plugins.css')); ?>" rel="stylesheet" type="text/css"/>
    <link href="<?php echo e(url('assets/admin/layout2/css/layout.css')); ?>" rel="stylesheet" type="text/css"/>
    <link id="style_color" href="<?php echo e(url('assets/admin/layout2/css/themes/default.css')); ?>" rel="stylesheet"
          type="text/css"/>
    <link href="<?php echo e(url('')); ?>/assets/global/plugins/toastr/toastr.min.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo e(url('assets/admin/layout2/css/custom.css')); ?>" rel="stylesheet" type="text/css"/>
    <!-- END THEME STYLES -->
        <link rel="icon"  type="image/x-icon" href="https://demo1.allin1uae.com/assets/images/1621929665app.png"/>

    <style>
        .login-btn{
            background-color: #c2943c !important;
        }
        .login-btn:hover{
            background-color: #c59f54 !important;
        }
        .company{
            color: #FFFFFF;
            text-decoration: underline;
            font-weight: bold;
        }
    </style>

    <?php echo $__env->make('partials.js_css.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<!-- END HEAD -->
<!-- BEGIN BODY -->
<body class="login">
<!-- BEGIN LOGO -->
<div class="logo">
    <a href="<?php echo e(url('login')); ?>">
        <img style="width: 150px;" src="<?php echo e(url('assets/img/bg-logo.png')); ?>" alt=""/>
    </a>
</div>
<!-- END LOGO -->
<!-- BEGIN SIDEBAR TOGGLER BUTTON -->
<div class="menu-toggler sidebar-toggler">
</div>
<!-- END SIDEBAR TOGGLER BUTTON -->
<!-- BEGIN LOGIN -->
<div class="content">
    <!-- BEGIN LOGIN FORM -->
    <form id="login_form" action="<?php echo e(route('doLogin')); ?>" method="post">
        <input type="hidden" value="<?php echo e(csrf_token()); ?>" name="_token">
        <div class="alert alert-danger" id="form-error" style="display: none"></div>
        <h3 class="form-title">Login to your account</h3>
        
        <div class="form-group">
            <!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
            <label class="control-label visible-ie8 visible-ie9">Email</label>
            <div class="input-icon">
                <i class="fa fa-envelope"></i>
                <input required class="form-control placeholder-no-fix" type="email" autocomplete="off"
                       placeholder="Email" name="email"/>
            </div>
        </div>
        <div class="form-group" style="margin-bottom: 5px">
            <label class="control-label visible-ie8 visible-ie9">Password</label>
            <div class="input-icon">
                <i class="fa fa-lock"></i>
                <input required class="form-control placeholder-no-fix" type="password" autocomplete="off"
                       placeholder="Password" name="password"/>
            </div>
        </div>
        <div class="form-group">
            <div class="input-icon">
                <div class="reset-password">
                    <a data-toggle="modal" data-target="#resetPasswordModal" style="color: #FFFFFF" href="#">Forget password ?</a>
                </div>
            </div>
        </div>
        <div class="form-actions">
            <label class="checkbox">
                <input type="checkbox" name="remember"/> Remember me </label>
            <button type="submit" class="btn blue pull-right login-btn show-login-popup">
                Login <i class="m-icon-swapright m-icon-white"></i>
            </button>
            <br>
            <br>
            <div class="copyright">
                © Copyrights <a class="company" href="https://etechnocode.com/" target="_blank" ><?php echo e(company()); ?></a> <?php echo e(date('Y')); ?>. All rights reserved.
            </div>
        </div>
    </form>
</div>

<!-- reset password -->
<!-- Modal -->
<div class="modal fade" id="resetPasswordModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <form method="post" id="resetPasswordForm">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Reset Password</h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Email</label>
                    <input class="form-control" type="email" required name="email">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Reset Password</button>
            </div>
        </div>
    </div>
    </form>
</div>


<!-- END LOGIN -->
<!-- BEGIN COPYRIGHT -->
<!-- END COPYRIGHT -->
<!-- BEGIN JAVASCRIPTS(Load javascripts at bottom, this will reduce page load time) -->
<!-- BEGIN CORE PLUGINS -->
<!--[if lt IE 9]>
<script src="<?php echo e(url('assets/global/plugins/respond.min.js')); ?>"></script>
<script src="<?php echo e(url('assets/global/plugins/excanvas.min.js')); ?>"></script>
<![endif]-->
<script src="<?php echo e(url('assets/global/plugins/jquery.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(url('assets/global/plugins/jquery-migrate.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(url('assets/global/plugins/bootstrap/js/bootstrap.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(url('assets/global/plugins/jquery.blockui.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(url('assets/global/plugins/uniform/jquery.uniform.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(url('assets/global/plugins/jquery.cokie.min.js')); ?>" type="text/javascript"></script>
<!-- END CORE PLUGINS -->
<!-- BEGIN PAGE LEVEL PLUGINS -->
<script src="<?php echo e(url('assets/global/plugins/jquery-validation/js/jquery.validate.min.js')); ?>"
        type="text/javascript"></script>
<script src="<?php echo e(url('assets/global/plugins/backstretch/jquery.backstretch.min.js')); ?>" type="text/javascript"></script>
<script type="text/javascript" src="<?php echo e(url('assets/global/plugins/select2/select2.min.js')); ?>"></script>
<!-- END PAGE LEVEL PLUGINS -->
<!-- BEGIN PAGE LEVEL SCRIPTS -->
<script src="<?php echo e(url('assets/global/scripts/metronic.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(url('assets/admin/layout2/scripts/layout.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(url('assets/admin/layout2/scripts/demo.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(url('assets/admin/pages/scripts/login-soft.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(url('')); ?>/assets/global/plugins/toastr/toastr.min.js" type="text/javascript"></script>
<!-- END PAGE LEVEL SCRIPTS -->
<script>
    jQuery(document).ready(function () {
        var toastar_options = toastr.options = {
            "closeButton": false,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-top-center",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "8000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        };

        Metronic.init(); // init metronic core components
        Layout.init(); // init current layout
        Login.init();
        Demo.init();
        // init background slide images
        $.backstretch([
                "<?php echo e(url('assets/admin/pages/media/bg/1.jpg')); ?>",
                "<?php echo e(url('assets/admin/pages/media/bg/2.jpg')); ?>",
                "<?php echo e(url('assets/admin/pages/media/bg/3.jpg')); ?>",
                "<?php echo e(url('assets/admin/pages/media/bg/4.jpg')); ?>"
            ], {
                fade: 1000,
                duration: 8000
            }
        );
        //login form
        $(document).on("submit", "#login_form", function (e) {
            var self = $(this);
            e.preventDefault();
            $("#form-error").hide();
            $("#loginModal").modal('show');
            self.find("button[type=submit]").attr("disabled","disabled");
            var remember = (self.find("input[name=remember]").is(":checked")) ? 1:0;
            $.ajax({
                "url": "<?php echo e(url('doLogin')); ?>",
                "type": "POST",
                "dataType": "JSON",
                "data": {
                    'email': self.find("input[name=email]").val(),
                    'password': self.find("input[name=password]").val(),
                    'remember': remember,
                    '_token': self.find("input[name=_token]").val()
                },
                "success": function (data) {
                    if(data.success){
                        window.location = '<?php echo e(set_route('dashboard')); ?>';
                    }else{
                        $("#loginModal").modal('hide');
                        self.find("button[type=submit]").removeAttr("disabled");
                        $("#form-error").show().html(data.errors);
                    }
                },
                "error": function () {
                    $("#loginModal").modal('hide');
                    self.find("button[type=submit]").removeAttr("disabled");
                }
            });
        });
        //reset password form
        $(document).on("submit","#resetPasswordForm",function(e){
          var self = $(this);
          e.preventDefault();
            self.find("button[type=submit]").attr("disabled","disabled");
            $.ajax({
                "url": "<?php echo e(url('reset-password')); ?>",
                "type": "POST",
                "dataType": "JSON",
                "data": {
                    'email': self.find("input[name=email]").val(),
                    '_token': '<?php echo e(csrf_token()); ?>'
                },
                "success": function (data) {
                    if(data.success){
                        $("#resetPasswordModal").modal('hide');
                        toastr.success(data.message,toastar_options);
                        self.find("button[type=submit]").removeAttr("disabled");
                        self.reset();
                    }else{
                        $("#loginModal").modal('hide');
                        self.find("button[type=submit]").removeAttr("disabled");
                        toastr.error(data.message,toastar_options);
                    }
                },
                "error": function () {
                    self.find("button[type=submit]").removeAttr("disabled");
                }
            });
        });
    });
</script>
<!-- END JAVASCRIPTS -->
</body>
<!-- END BODY -->
</html><?php /**PATH /home/royalteamcare/public_html/royal/resources/views/login/index.blade.php ENDPATH**/ ?>