<?php

namespace App\Http\Controllers;

use App\Models\Booking;
use App\Models\Reservation;
use App\Models\ReservationLeader;
use App\Models\Service;
use App\Models\Worker;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class DashboardController extends Controller
{


    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $users = User::where('role_id',3)->orderBy('id','desc')->get()->count();
        $users_list = User::where('role_id',3)->orderBy('id','desc')->get();
        $temp_bookings = Booking::where('id','>',0)->orderBy('id','desc');
        if(get_user_role()==2){
            $temp_bookings->where('branch_id',Auth::user()->branch_id);
        }
        $bookings = $temp_bookings->get()->count();
        $bookings_list = $temp_bookings->limit(100)->get();

        $temp_workers = Worker::where('id','>',0);
        if(Auth::user()->role_id==2){
            $temp_workers->where('branch_id',Auth::user()->branch_id);
        }
        $workers = $temp_workers->get()->count();
        $services = Service::get()->count();



        return view('dashboard.index',compact('users','bookings','services','workers','bookings_list','users_list'));
    }
    public  static function r(){
        die('Access denied');
    }

    public function clearCache(){
        Artisan::call("optimize");
        return true;
    }
    
    public function home(){
        return redirect()->to(app()->getLocale());
    }
}
