<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Mail;
use Illuminate\Http\Request;

class LoginController extends Controller
{
    public function index()
    {

        return view('login/index');
    }

    public function doLogin(Request $request)
    {
        $message = 'Error in email / password.';
        $validated = Validator::make($request->all(), [
            'email' => 'required|email:rfc',
            'password' => 'required'
        ]);
        if ($validated->fails()) {
            $error = $validated->errors()->first();
            return response()->json([
                'success' => false,
                'errors' => $error
            ]);
        } else {
            $remember = ($request->get('remember')) ? true : false;
            $email = $request->get('email');
            $password = $request->get('password');
            if (Auth::attempt(['email' => $email, 'password' => $password], $remember)) {
                Auth::user();
                return response()->json([
                    'success' => true,
                ]);
            }
            return response()->json([
                'success' => false,
                'errors' => $message
            ]);
        }

    }

    public function checkLogin(Request $request)
    {
        $main_id = Auth::user()->id;
        $name = $request->get('name');
        $name = decryptTo($name);
        $response = [
            'success' => false,
            'message' => 'An error occurs !'
        ];
        switch ($name) {
            case 'e_commerce';
                $response = $this->doCommerceLogin($main_id);
                $response['back_url'] = "p-login";
                break;
            case 'classification';
                $response = $this->doClassificationLogin($main_id);
                $response['back_url'] = "en/p-login";
                break;
        }
        return response()->json($response);
    }

    public function logout(Request $request)
    {
        Auth::logout();
        return redirect('login');
    }

    public function reset_password(Request $request){
        $validated = Validator::make($request->all(), [
            'email' => 'required|email:rfc',
        ]);
        if ($validated->fails()) {
            $error = $validated->errors()->first();
            return response()->json([
                'success' => false,
                'message' => $error
            ]);
        }else{
            //check if email exist
            $check = User::where('email',$request->get('email'))->first();
            if(!empty($check)){
                return response()->json([
                    'success' => true,
                    'message' => "Reset link was sent to your email."
                ]);
            }else{
                return response()->json([
                    'success' => false,
                    'message' => "Email is not exist in our system."
                ]);
            }
        }
    }


    public function change_password(Request $request){

        $message_result = [];
        $valid = [
            'password'=>'required|confirmed'
        ];
        $validator = Validator::make($request->all(), $valid);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }else{
            $user_password = Auth::user()->getAuthPassword();
            if(!Hash::check($request->current_password,$user_password)){
                return response()->json(['success' => false, 'message' => "Current password not valid"]);
            }
            $user = User::find(Auth::id());
            $user->password = Hash::make($request->get('password'));
            $user->save();
            return response()->json(['success' => true, 'message' => "Password was changed successfully"]);
        }
    }

}
