<?php

namespace App\Http\Controllers\Worker;

use App\Models\Branch;
use App\Models\Service;
use App\Models\Shift;
use App\Models\WeekDay;
use App\Models\Worker;
use App\Models\Role;
use App\Models\WorkerService;
use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use DataTables;

class WeekDayController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {

        can('worker.view',true);
        if ($request->ajax()) {
            $data = WeekDay::select('*');
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function($row){
                    return ucfirst($row->name);
                })
                ->addColumn('opening_status', function($row){
                    $template = "<select data-id='".$row->id."' name='opening_status' class='opening_status form-control'>";
                    $selected = "";
                    if($row->opening_status=="open"){
                        $selected = "selected=''";
                    }
                    $template .= "<option $selected value='open'>Open</option>";
                    $selected = "";
                    if($row->opening_status=="closed"){
                        $selected = "selected=''";
                    }
                    $template .= "<option $selected value='closed'>Closed</option>";
                    $template .= "</select>";
                    return $template;
                })
                ->addColumn('action', function($row){
                    $btn = "";
                    if(can('worker.edit')){
                        $btn.='<a href="" class="btn btn-primary btn-xs edit-worker" data-id="'.$row->id.'" data-target="#editModal" data-toggle="modal">
                                    <i class="fa fa-edit"></i>
                                </a>';
                    }
                    return $btn;
                })
                ->rawColumns(['action','image','opening_status'])
                ->make(true);
        }
        $branches = Branch::where('status','Active')->get();
        $services = Service::where('status','Active')->get();
        $shifts = Shift::where('status','Active')->get();
        return view('weekday.index',compact('branches','services','shifts'));
    }
    public function update(Request $request){
        WeekDay::where('id',$request->get('id'))->update([
            'opening_status'=>$request->get('opening_status')
        ]);
        return response()->json(['success'=>true,'message'=>__('s.data_saved')]);
    }
}
