<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8" />
    <title>Invoice</title>

    <style>
        .invoice-box {
            max-width: 100%;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            /*box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);*/
            font-size: 16px;
            line-height: 24px;
            font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
            color: #555;
        }

        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: left;
        }

        .invoice-box table td {
            padding: 5px;
            vertical-align: top;
        }

        .invoice-box table tr td:nth-child(2) {
            text-align: right;
        }

        .invoice-box table tr.top table td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.top table td.title {
            font-size: 45px;
            line-height: 45px;
            color: #333;
        }

        .invoice-box table tr.information table td {
            padding-bottom: 40px;
        }

        .invoice-box table tr.heading td {
            background: #eee;
            border-bottom: 1px solid #ddd;
            font-weight: bold;
        }

        .invoice-box table tr.details td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.item td {
            border-bottom: 1px solid #eee;
        }

        .invoice-box table tr.item.last td {
            border-bottom: none;
        }

        .invoice-box table tr.total td:nth-child(2) {
            border-top: 2px solid #eee;
            font-weight: bold;
        }

        @media only screen and (max-width: 600px) {
            .invoice-box table tr.top table td {
                width: 100%;
                display: block;
                text-align: center;
            }

            .invoice-box table tr.information table td {
                width: 100%;
                display: block;
                text-align: center;
            }
        }

        /** RTL **/
        .invoice-box.rtl {
            direction: rtl;
            font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
        }

        .invoice-box.rtl table {
            text-align: right;
        }

        .invoice-box.rtl table tr td:nth-child(2) {
            text-align: left;
        }
    </style>
</head>

<body>
<div class="invoice-box">
    <table cellpadding="0" cellspacing="0">
        <tr class="top">
            <td colspan="2">
                <table>
                    <tr>
                        <td class="title">
                            <img src="{{ public_path('assets/img/bg-logo.png') }}" style="width: 150px;height: auto" />
                        </td>

                        <td>
                            Invoice #: {{ $result->id }}<br />
                            Created: {{ date('d-m-Y') }}<br />
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

        <tr class="information">
            <td colspan="2">
                <table>
                    <tr>
                        <td>
                            Abu Dhabi, Madinat Zayed Branch<br>
                            Al Dhafra Region <br>Emirates Building
                        </td>

                        <td>
                            {{ $result->full_name }}<br />
                            {{ $result->mobile }}<br />
                            {{ $result->email }}
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

        @if(!empty($result->payment_type))
            <tr class="heading">
                <td colspan="2">Payment Method</td>
            </tr>

            <tr class="details">
                <td colspan="2">{{ \App\Http\Controllers\Booking\BookingController::get_payment_types($result->payment_type) }}</td>
            </tr>
        @endif

        @if(!empty($result->wallet))
            <tr class="heading">
                <td colspan="2">Wallet</td>
            </tr>

            <tr class="details">
                <td colspan="2">{{ $result->wallet->code }}</td>
            </tr>
        @endif



        <tr class="heading">
            <td>Service</td>

            <td>Price</td>
        </tr>
        @php
            $service_price = 0;
        @endphp
        @if(!$result->details->isEmpty())
            @foreach($result->details as $detail)
                <tr class="item">
                    <td>
                        {{ $detail->service->name_en }}<br>
                        <small>{{ $detail->_date }}</small><br>
                        <small>{{ $detail->from_time ." - ". $detail->to_time }}</small>
                    </td>
                    @if($detail->is_free==1)
                        <td>Free</td>
                        @else
                        <td>AED {{ number_format($detail->price , 2, '.', '') }}</td>
                        @endif
                </tr>
                @php
                    if($detail->is_free!=1)
                    $service_price+=$detail->price;
                @endphp
            @endforeach
            @php
                $discount_amount = 0;
                $card_amount = 0;
            @endphp
            @if(!empty($result->discount_code))
                <tr class="heading">
                    <td>Discount Code</td>
                    <td>Amount</td>
                </tr>
                <tr class="details">
                    <td>{{ $result->discount_code->code }}</td>
                    <td>
                        @if($result->discount_code->type!="fixed")
                            @php
                                $discount_amount =  ($service_price * $result->discount_code->amount) / 100;
                            @endphp
                            AED {{ get_num_format(($service_price * $result->discount_code->amount) / 100) }}
                        @else
                            @php
                                $discount_amount =  $result->discount_code->amount;
                            @endphp
                            AED {{ get_num_format($result->discount_code->amount) }}
                        @endif
                    </td>
                </tr>
            @endif

            @if(!empty($result->card))
                <tr class="heading">
                    <td>Member Ship Card</td>
                    <td>Amount</td>
                </tr>
                <tr class="details">
                    <td>{{ $result->card->code }}</td>
                    <td>
                        @php
                            $card_amount =  ($service_price * $result->card->amount) / 100;
                        @endphp
                        {{--AED {{ ($service_price * $result->card->amount) / 100 }}--}}
                        {{ number_format($result->card->amount) }}%
                    </td>
                </tr>
            @endif


            <tr class="total">
                <td></td>
                <td>Total: AED {{ number_format($service_price - $discount_amount - $card_amount , 2, '.', '') }}</td>
            </tr>
        @endif
    </table>
</div>
</body>
</html>
