@extends('layout')
@section('content')
    <div class="row">
        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
            <a class="dashboard-stat dashboard-stat-v2 blue" href="{{ set_route('account') }}">
                <div class="visual">
                    <i class="fa fa-comments"></i>
                </div>
                <div class="details">
                    <div class="number">
                        <span data-counter="counterup" data-value="{{ $users }}">
                            {{ $users }}
                        </span>
                    </div>
                    <div class="desc"> {{ __('s.accounts') }}</div>
                </div>
            </a>
        </div>


        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
            <a class="dashboard-stat dashboard-stat-v2 green" href="{{ set_route('booking') }}">
                <div class="visual">
                    <i class="fa fa-shopping-cart"></i>
                </div>
                <div class="details">
                    <div class="number">
                        <span data-counter="counterup" data-value="{{ $bookings }}">{{ $bookings }}</span>
                    </div>
                    <div class="desc"> {{ __('s.bookings') }}</div>
                </div>
            </a>
        </div>

        @if(\Illuminate\Support\Facades\Auth::user()->role_id==1)
            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <a class="dashboard-stat dashboard-stat-v2 red" href="{{ set_route('worker') }}">
                    <div class="visual">
                        <i class="fa fa-bar-chart-o"></i>
                    </div>
                    <div class="details">
                        <div class="number">
                        <span data-counter="counterup" data-value="{{ $workers }}">
                            {{ $workers }}
                        </span>
                        </div>
                        <div class="desc"> {{ __('s.employees') }} </div>
                    </div>
                </a>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <a class="dashboard-stat dashboard-stat-v2 purple" href="{{ set_route('service') }}">
                    <div class="visual">
                        <i class="fa fa-globe"></i>
                    </div>
                    <div class="details">
                        <div class="number">
                            <span data-counter="counterup" data-value="{{ $services }}">{{ $services }}</span></div>
                        <div class="desc"> {{ __('s.services') }} </div>
                    </div>
                </a>
            </div>
        @endif
    </div>


    <div class="row">
        <div class="col-md-6">
            <div class="portlet box blue-hoki">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-plus"></i>{{ __('s.Bookings List') }}
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="booking_table">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ __('s.branch') }}</th>
                                <th>{{ __('s.services') }}</th>
                                <th>{{ __('s.full_name') }}</th>
                                <th>{{ __('s.mobile') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if(!$bookings_list->isEmpty())
                                @php
                                    $count = 0;
                                @endphp
                                @foreach($bookings_list as $item)
                                    @php
                                        if($count++==10){
                                         continue;
                                        }
                                    @endphp
                                    <tr>
                                        <td>{{ $item->id }}</td>
                                        <td>
                                            @if(!empty($item->branch))
                                                {{ $item->branch->name_en }}
                                                @endif
                                        </td>
                                        <td>
                                            @if(!$item->details->isEmpty())
                                                @foreach($item->details as $detail)
                                                    @if(!empty($detail->service))
                                                        {{ $detail->service->name_en }}<br>
                                                        @endif
                                                    @endforeach
                                                @endif
                                        </td>
                                        <td>
                                            {{ $item->full_name }}
                                        </td>
                                        <td>
                                            +971{{ $item->mobile }}
                                        </td>
                                    </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="portlet box blue-hoki">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-plus"></i>{{ __('s.Accounts List') }}
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="booking_table">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ __('s.first_name') }}</th>
                                <th>{{ __('s.first_name') }}</th>
                                <th>{{ __('s.wallet') }}</th>
                                <th>{{ __('s.phone') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if(!$users_list->isEmpty())
                                @php
                                $count = 0;
                                @endphp
                                @foreach($users_list as $item)
                                    @php
                                    if($count++==10){
                                     continue;
                                    }
                                    @endphp
                                    <tr>
                                        <td>{{ $item->id }}</td>
                                        <td>
                                            {{ $item->first_name }}
                                        </td>
                                        <td>
                                            {{ $item->last_name }}
                                        </td>
                                        <td>
                                            {{ get_num_format($item->wallet) }}
                                        </td>
                                        <td>
                                            {{ $item->country_code }}{{ $item->phone }}
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@push('scripts')
<script type="text/javascript">
    $(document).ready(function () {

    });
</script>
@endpush