@extends('layout')
@section('content')

    <div class="portlet box blue-hoki">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-plus"></i>Commissions
            </div>
        </div>
        <div class="portlet-body">
            <div class="row">
                <form method="get" action="{{ set_route('report.commission_reports') }}">
                    <div class="col-md-3">
                        <label>{{ __('Year') }}</label>
                        <select class="form-control select" name="year" required>
                            @if (!empty($years))
                                @foreach ($years as $year)
                                    @php
                                        $selected = '';
                                        if ($year == $selected_year) {
                                            $selected = 'selected=""';
                                        }
                                    @endphp
                                    <option {{ $selected }} value="{{ $year->year }}">{{ $year->year }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label>{{ __('Month') }}</label>
                        <select class="form-control select" name="month" required>
                            @for ($i = 1; $i <= 12; $i++)
                                @php
                                    $selected = '';
                                    if ($i == $selected_month) {
                                        $selected = 'selected=""';
                                    }
                                @endphp
                                <option {{ $selected }} value="{{ $i }}">
                                    {{ date('F', mktime(0, 0, 0, $i, 10)) }}</option>
                            @endfor
                        </select>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Branch</label>
                            <select class="form-control" name="branch_id">
                                @if (get_user_role() == 1)
                                    <option value="">All Branches</option>
                                @endif
                                @if (!empty($branches))
                                    @foreach ($branches as $branch)
                                        @php
                                            $selected = '';
                                            if ($branch->id == $selected_branch) {
                                                $selected = 'selected=""';
                                            }
                                        @endphp
                                        <option {{ $selected }} value="{{ $branch->id }}">{{ $branch->name_en }}
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label><br>
                            <button class="btn btn-success">View</button>
                            @if (isset($request) && !empty($request->has('year')))
                                <a target="_blank"
                                    href="{{ set_route('report.commission_reports') }}?year={{ $request->get('year') }}&month={{ $request->get('month') }}&branch_id={{ $request->get('branch_id') }}&is_pdf=true"
                                    class="btn btn-primary">PDF</a>
                            @endif
                        </div>
                    </div>
                </form>
            </div>
            <div class="row">
                <div class="col-md-12">
                    {!! $template !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        $(document).ready(function() {
            $(".date-format").datetimepicker({
                "format": "DD/MM/Y"
            });
        });
    </script>
@endpush
