<div class="table-responsive">
    <table class="table table-bordered">
        <thead>
            <tr>
                <th colspan="{{ count($users) }}">{{ 'DAILY REPORT FOR :' . $var }}</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                @foreach ($users as $user)
                    <td style="text-align: center"><strong>{{ $user->name }}</strong></td>
                @endforeach
            </tr>
            @php
                $total_with_users = [];
            @endphp
            <tr>
                @foreach ($users as $user)
                    @php
                        $user_total = 0;
                    @endphp
                    <td>
                        @if (isset($users_with_prices[$user->id]))
                            @foreach ($users_with_prices[$user->id] as $with_price)
                                @php
                                    $user_total += $with_price;
                                @endphp
                                {{ get_num_format($with_price) }}<br>
                            @endforeach
                            @php
                                $total_with_users[$user->id] = $user_total;
                            @endphp
                        @endif
                    </td>
                @endforeach
            </tr>

            <tr>
                @foreach ($users as $user)
                    <td style="padding: 15px"></td>
                @endforeach
            </tr>

            {{-- Total Of Each Employee --}}
            <tr>
                @foreach ($users as $user)
                    <td>
                        @if (isset($total_with_users[$user->id]))
                            <strong>{{ get_currency() . get_num_format($total_with_users[$user->id]) }}</strong>
                        @endif
                    </td>
                @endforeach
            </tr>

            @php
                $total_payments_types = [];
            @endphp
            @if (!empty($payments_type))
                @foreach ($payments_type as $index => $value)
                    @php
                        $total_with_users = [];
                    @endphp
                    @if (isset($payments_with_prices[$index]) && !empty($payments_with_prices[$index]))
                        <tr>
                            <td colspan="{{ count($users) }}">
                                <strong>{{ $value }}</strong>
                            </td>
                        </tr>

                        <tr>
                            @foreach ($users as $user)
                                @php
                                    $user_total = 0;
                                @endphp
                                <td>
                                    @if (isset($payments_with_prices[$index][$user->id]))
                                        @foreach ($payments_with_prices[$index][$user->id] as $with_price)
                                            @php
                                                // dd($payments_with_prices);
                                                $with_price_sum = is_array($with_price) ? $with_price['amount'] : $with_price;
                                                $user_total += $with_price_sum;
                                            @endphp
                                            @if (is_array($with_price))
                                                <div
                                                    style="color: {{ get_color_type($with_price['type']) }};border-bottom: 1px solid">
                                                    @php
                                                        // dd($with_price)
                                                    @endphp
                                                    @if (optional($with_price)['details'])
                                                        @foreach ($with_price['details'] as $key => $amountItem)
                                                            <span>
                                                                {{ $amountItem }}
                                                                {{ get_symbol_type($with_price['type']) }}
                                                                @if (!empty($with_price['codesArr'][$key]))
                                                                    <br>{{ $with_price['codesArr'][$key] }}
                                                                @endif
                                                                <br>
                                                                {{ $with_price['detailsArr'][$key]->full_name }}
                                                                <br>
                                                                {{ $with_price['detailsArr'][$key]->mobile }}
                                                            </span>
                                                            @if (!$loop->last)
                                                                <hr style="margin-top:5px;margin-bottom:5px;">
                                                            @endif
                                                        @endforeach
                                                    @else
                                                        {{ $with_price['amount'] }}
                                                        {{ get_symbol_type($with_price['type']) }}
                                                        @if (!empty($with_price['code']))
                                                            <br> lama {{ $with_price['code'] }}
                                                        @endif
                                                        <br>{{ $with_price['client_name'] }}
                                                    @endif
                                                </div>
                                            @else
                                                {{ get_num_format($with_price) }}
                                            @endif
                                            <br>
                                            @php
                                                if (isset($total_payments_types[$index])) {
                                                    $total_payments_types[$index] += $with_price_sum;
                                                } else {
                                                    $total_payments_types[$index] = $with_price_sum;
                                                }
                                            @endphp
                                        @endforeach
                                        @php
                                            $total_with_users[$user->id] = $user_total;
                                        @endphp
                                    @endif
                                </td>
                            @endforeach
                        </tr>
                        <!-- For total -->
                        <tr>
                            @foreach ($users as $user)
                                <td>
                                    @if (isset($total_with_users[$user->id]))
                                        <strong>{{ get_currency() . get_num_format($total_with_users[$user->id]) }}</strong>
                                    @endif
                                </td>
                            @endforeach
                        </tr>
                    @endif
                @endforeach
            @endif

            <!-- For commission -->
            @php
                $total_commission = 0;
            @endphp
            <tr>
                <td colspan="{{ count($users) }}">
                    <strong>Commission</strong>
                </td>
            </tr>
            @if (!empty($users_with_commission))
                <tr>
                    @foreach ($users_with_commission as $user_id => $commission)
                        <td>
                            @if (!empty($commission))
                                @foreach ($commission as $commission_value)
                                    @php
                                        $total_commission += $commission_value;
                                    @endphp
                                    {{ get_num_format($commission_value) }}<br>
                                @endforeach
                            @endif
                        </td>
                    @endforeach
                </tr>
            @endif

        </tbody>
    </table>
    @php
        $getPaymentsTypes = \App\Http\Controllers\Booking\BookingController::get_payment_types();
        $last_total = 0;
    @endphp
    <table class="table table-bordered">
        <tbody>
            <tr>
                <td colspan="{{ count($users) }}">
                    <h3 style="margin-bottom: 0;margin-top: 0">
                        <strong>{{ __('s.total') }}</strong>
                    </h3>
                </td>
            </tr>

            @if (!empty($getPaymentsTypes))
                @foreach ($getPaymentsTypes as $getPaymentsType => $type)
                    @php
                        if (!isset($total_payments_types[$getPaymentsType])) {
                            continue;
                        }
                    @endphp
                    @php
                        if ($getPaymentsType != 'free' && $getPaymentsType != 'wallet') {
                            $last_total += $total_payments_types[$getPaymentsType];
                        }
                    @endphp
                    <tr>
                        <td style="width: 150px"><strong>{{ $type }}</strong></td>
                        <td>
                            <strong>{{ get_currency() . get_num_format($total_payments_types[$getPaymentsType]) }}</strong>
                        </td>
                    </tr>
                @endforeach
            @endif

            @foreach ($product_details_prices as $index => $product_details_price)
                @if ($product_details_price != 0)
                    @php
                        $last_total += $product_details_price;
                    @endphp
                    <tr>
                        <td style="width: 150px"><strong>{{ __('s.' . $index) }}</strong></td>
                        <td>
                            <strong>{{ get_currency() . get_num_format($product_details_price) }}</strong>
                        </td>
                    </tr>
                @endif
            @endforeach


            <!-- for wallet -->
            @foreach ($wallet_details_prices as $index => $wallet_details_price)
                @if ($wallet_details_price != 0)
                    @php
                        $last_total += $wallet_details_price;
                    @endphp
                    <tr>
                        <td style="width: 150px">
                            <strong>
                                @if ($index == 'sales_cash')
                                    {{ __('s.sales_cash_cp') }}
                                @else
                                    {{ __('s.sales_visa_cp') }}
                                @endif
                            </strong>
                        </td>
                        <td>
                            <strong>{{ get_currency() . get_num_format($wallet_details_price) }}</strong>
                        </td>
                    </tr>
                @endif
            @endforeach
            <!-- for total commission -->
            <tr>
                <td style="width: 150px">
                    <strong>
                                {{ __('s.commission') }}
                    </strong>
                </td>
                <td>
                    <strong>{{ get_currency() . get_num_format($total_commission) }}</strong>
                </td>
            </tr>

            <tr style="background-color: #666666;color: #ffffff">
                <td style="width: 150px"><strong>{{ __('s.total') }}</strong></td>
                <td colspan="{{ count($users) }}">
                    <strong>{{ get_currency() . get_num_format($last_total) }}</strong>
                </td>
            </tr>

        </tbody>
    </table>

</div>
