<?php

namespace App\Http\Controllers\Account;

use App\Models\Branch;
use App\Models\Role;
use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use DataTables;

class AccountController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {

        can('account.view', true);
        if ($request->ajax()) {
			
			
            $data = User::where('id', '!=', 1)->select('*');
			
			 if (Auth::user()->role_id == 4) {
                $data->where('role_id','!=', 4)->where('role_id','!=', 1);
            }
         
 		 if (Auth::user()->role_id == 2) {
                $data->where('role_id', 3);
            }

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('phone', function ($row) {
                    return $row->country_code . $row->phone;
                })
                ->addColumn('branch', function ($row) {
                    return (!empty($row->branch)) ? $row->branch->name_en : '';
                })
                ->addColumn('role', function ($row) {
                    return (!empty($row->role)) ? $row->role->name : '';
                })
                ->addColumn('action', function ($row) {
                    $btn = "";
                    if (can('account.edit')) {
                        $btn .= '<a href="" class="btn btn-primary btn-xs edit-user"  data-id="' . $row->id . '" data-target="#editModal" data-toggle="modal">
                                    <i class="fa fa-edit"></i>
                                </a>';
                    }
                    if (Auth::user()->role_id == 1||Auth::user()->role_id == 4) {
                        $btn .= '<a href="' . set_route('account.delete', ['id' => $row->id]) . '" class="btn btn-danger btn-xs delete-row">
                                    <i class="fa fa-close"></i>
                                </a>';
                    }
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
        $roles = Role::get();
        $branches = Branch::all();
        return view('account.index', compact('roles', 'branches'));
    }
    //create
    public function create(Request $request)
    {
        can('account.create', true);
        $roles = Role::all();
        return view('account.create', compact('roles'));
    }
    public function store(Request $request)
    {
        can('account.create', true);
        $message_result = [];
        $valid = [
            'first_name' => 'required'
        ];
        if (!empty($request->get('password'))) {
            $valid['password'] = 'required|confirmed';
        }
        $validator = Validator::make($request->all(), $valid);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        } else {
            //check phone
            $check = User::where('phone', $request->get('phone'))
                ->whereNull('deleted_at')
                ->first();
            if (!empty($check)) {
                return response()->json(['success' => false, 'message' => __('s.phone_already_exist')]);
            }
            //check email
            if ($request->get('email')) {
                $check = User::where('email', $request->get('email'))
                    ->whereNull('deleted_at')
                    ->first();
                if (!empty($check)) {
                    return response()->json(['success' => false, 'message' => __('s.email_already_exist')]);
                }
            }
            //check if phone has zero
            $first_phone = substr($request->get('phone'), 0, 1);
            if ($first_phone == "0" || $first_phone == 0) {
                return response()->json(['success' => false, 'message' => __('s.phone_zero')]);
            }

            $data = $request->all();
            $data['password'] = Hash::make($request->get('password'));
            if (Auth::user()->role_id == 2) {
                $data['role_id'] = 3;
            }
            User::create($data);
            set_message('User was saved successfully.');
        }
        return response()->json(['success' => true, 'message' => 'User was created successfully.']);
    }
    //update
    public function edit(Request $request)
    {
        can('account.edit', true);
        $row = User::findOrFail($request->get('id'));
        return response()->json(['success' => true, 'row' => $row]);
    }
    public function update($id, Request $request)
    {
        can('account.edit', true);
        $user = User::findOrFail($request->get('id'));
        $message_result = [];
        $validation_array = [
            'first_name' => 'required',
        ];
        //check for password
        if (!empty($request->get('password'))) {
            $validation_array['password'] = 'required|confirmed';
        }
        $validator = Validator::make($request->all(), $validation_array);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }

        //check phone
        $check = User::where('phone', $request->get('phone'))
            ->whereNull('deleted_at')
            ->where('id', '!=', $user->id)
            ->first();
        if (!empty($check)) {
            return response()->json(['success' => false, 'message' => __('s.phone_already_exist')]);
        }
        //check email
        $check = User::where('email', $request->get('email'))
            ->whereNull('deleted_at')
            ->where('id', '!=', $user->id)
            ->first();
        if (!empty($check)) {
            return response()->json(['success' => false, 'message' => __('s.email_already_exist')]);
        }
        //check if phone has zero
        $first_phone = substr($request->get('phone'), 0, 1);
        if ($first_phone == "0" || $first_phone == 0) {
            return response()->json(['success' => false, 'message' => __('s.phone_zero')]);
        }


        $data = $request->all();
        if (!empty($request->get('password'))) {
            $data['password'] = Hash::make($request->get('password'));
        }
        $user->fill($data);
        $user->update();
        //User::where('id',$user->id)->update($request->all());
        return response()->json(['success' => true, 'message' => 'User was saved successfully.']);
    }
    //delete
    public function destroy(Request $request)
    {
        if (Auth::user()->role_id != 1) {
            dd("No");
        }
        $user = User::findOrFail($request->route('id'));
        $user->delete();
        set_message('User was delete successfully.');
        return redirect()->back();
    }
    //profile
    public function profile(Request $request)
    {
        return view('account.profile');
    }
    //update profile
    public function update_profile(Request $request)
    {
        $message_result = [];
        $validation_array = [
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'image' => 'mimes:png,jpg,jpeg|max:20000'
        ];
        $message_result = [];
        $validator = Validator::make($request->all(), $validation_array);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        } else {

            //check phone
            $check = User::where('phone', $request->get('phone'))
                ->whereNull('deleted_at')
                ->where('id', '!=', Auth::id())
                ->first();
            if (!empty($check)) {
                return response()->json(['success' => false, 'message' => __('s.phone_already_exist')]);
            }
            //check email
            $check = User::where('email', $request->get('email'))
                ->whereNull('deleted_at')
                ->where('id', '!=', Auth::id())
                ->first();
            if (!empty($check)) {
                return response()->json(['success' => false, 'message' => __('s.email_already_exist')]);
            }

            //check if phone has zero
            $first_phone = substr($request->get('phone'), 0, 1);
            if ($first_phone == "0" || $first_phone == 0) {
                return response()->json(['success' => false, 'message' => __('s.phone_zero')]);
            }
            $user = Auth::user();
            //for image
            $data = $request->all();
            $image = "";
            //upload image
            if ($request->file('image')) {
                $imagePath = $request->file('image');
                $imageName = time() . str_replace(' ', '', $imagePath->getClientOriginalName());
                $image = $request->file('image')->storeAs('users/profile/', $imageName, 'public');
            }
            $data['image'] = $image;


            $user->fill($data);
            $user->save();
            set_message('Profile updated successfully.');
            return response()->json(['success' => true, 'message' => 'Profile updated successfully.']);
        }
    }
}
