<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\User;

class ResetPasswordController extends Controller
{
    // عرض نموذج إعادة تعيين كلمة المرور
    public function showResetForm($token)
    {
        return view('auth.passwords.reset', ['token' => $token]);
    }

    // إعادة تعيين كلمة المرور
    public function reset(Request $request)
    {
        $request->validate([
            'token' => 'required',
            'email' => 'required|email',
            'password' => 'required|confirmed|min:6',
        ]);

        // التحقق مما إذا كان البريد الإلكتروني موجود في قاعدة البيانات
        $user = User::where('email', $request->email)->first();

        if (!$user) {
            return back()->withInput()->with('error', 'Invalid email.');
        }

        // تحديث كلمة المرور
        $user->password = Hash::make($request->password);
        $user->save();

        // تسجيل الدخول تلقائيًا بعد إعادة تعيين كلمة المرور
        auth()->login($user);

        return redirect('/login')->with('success', 'Password has been reset successfully!');
    }
}
