<?php

namespace App\Http\Controllers\Shift;

use App\Models\Shift;
use App\Models\Role;
use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use DataTables;

class ShiftController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {

        can('shift.view',true);
        if ($request->ajax()) {
            $data = Shift::select('*');
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = "";
                    if(can('shift.edit')){
                        $btn.='<a href="" class="btn btn-primary btn-xs edit-shift" data-id="'.$row->id.'" data-target="#editModal" data-toggle="modal">
                                    <i class="fa fa-edit"></i>
                                </a>';
                    }
                    if(can('shift.delete')){
                        $btn.='<a href="'.set_route('shift.delete',['id'=>$row->id]).'" class="btn btn-danger btn-xs delete-row">
                                    <i class="fa fa-close"></i>
                                </a>';
                    }
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
        $roles = Role::all();
        return view('shift.index',compact('roles'));
    }
    //create
    public function create(Request $request)
    {
        can('shift.create',true);
        $roles = Role::all();
        return view('shift.create',compact('roles'));
    }
    public function store(Request $request){
        can('shift.create',true);
        $message_result = [];
        $validator = Validator::make($request->all(), [
            'name' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }else{
            $data = $request->all();
            Shift::create($data);
            set_message('Shift was saved successfully.');
        }
        return response()->json(['success'=>true,'message'=>'Shift was saved successfully.']);
    }
    //update
    public function edit(Request $request){
        $row = Shift::find($request->get('id'));
        return response()->json(['success'=>true,'row'=>$row]);
    }
    public function update(Request $request){
        can('shift.edit',true);
        $data = $request->all();
        if(isset($data['_token'])){
            unset($data['_token']);
        }
        Shift::where('id',$request->get('id'))->update($data);
        return response()->json(['success'=>true,'message'=>'Shift was saved successfully.']);
    }
    //delete
    public function destroy(Request $request){
        can('shift.delete',true);
        $row = Shift::findOrFail($request->route('id'));
        $row->delete();
        set_message('Shift was delete successfully.');
        return redirect()->back();
    }
}
