<?php

namespace App\Http\Controllers;

use App\Models\SystemSettings;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Intervention\Image\Facades\Image;

class SystemSettingsController extends Controller
{
    public function index()
    {
       $Settings = SystemSettings::first();
        $languages = ['en', 'fr', 'ar']; // Replace with your actual language options
        return view('settings.system_settings', compact( 'languages','Settings'));
    }

  public function store(Request $request)
{
    $validatedData = $request->validate([
        'website_name' => 'required',
        'website_title' => 'required',
        'system_email' => 'required',
        'logo' => 'image|mimes:jpeg,png,jpg,gif|max:2048', // Ensure image file with allowed extensions
    ]);

    $systemSettings = SystemSettings::firstOrNew([]);

    // Save other form data
    $systemSettings->website_name = $request->input('website_name');
    $systemSettings->website_title = $request->input('website_title');
    $systemSettings->system_email = $request->input('system_email');
    $systemSettings->youtube_channel = $request->input('youtube_channel');
    $systemSettings->author = $request->input('author');
    $systemSettings->website_description = $request->input('website_description');
	 $systemSettings->address = $request->input('address');
	 $systemSettings->phone = $request->input('phone');
	 $systemSettings->footer_text = $request->input('footer_text');
	  $systemSettings->language = $request->input('language');
	  $systemSettings->tips = $request->input('tips');
	 
    // Handle logo
    if ($request->hasFile('logo')) {
        // Define the new image path
        $imagePath = public_path('assets/img/bg-logo.png');

        // Convert the image to PNG format
        $image = Image::make($request->file('logo'))->encode('png');

        // Save the image to the specified path
        $image->save($imagePath);

        // Save the image path to the database
        $systemSettings->logo = 'assets/img/bg-logo.png';
    } elseif (!$systemSettings->logo) {
        // If no logo uploaded and no existing logo in the database, use default
        $systemSettings->logo = 'assets/img/bg-logo.png';
    }

    // Save the system settings
     $systemSettings->save();
	 
     set_message('Settings saved successfully.');
  
    return redirect()->back();
}

  
}
