<?php

namespace App\Http\Controllers\User;

use App\Models\Permission;
use App\Models\PermissionRole;
use App\Models\Role;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use DataTables;


class RoleController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        can('role.view',true);
        if ($request->ajax()) {
            $data = Role::select('*');
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = "";
                    if(can('role.edit')){
                        $btn.='<a href="'.url('role/'.$row->id.'/edit').'" class="btn btn-primary btn-xs">
                                    <i class="fa fa-edit"></i>
                                </a>';
                    }
                    if(can('role.delete')){
                        $btn.='<a href="'.url('role/'.$row->id.'/delete').'" class="btn btn-danger btn-xs delete-row">
                                    <i class="fa fa-close"></i>
                                </a>';
                    }
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('role.index');
    }
    //create
    public function create(Request $request)
    {
        can('role.create',true);
        $permissions = Permission::all();
        return view('role.create',compact('permissions'));
    }
    public function store(Request $request){
        can('role.create',true);
        $message_result = [];
        $validator = Validator::make($request->all(), [
            'name' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }else{
            DB::transaction(function () use ($request) {
                $role = Role::create([
                    'name'=>$request->get('name'),
                ]);
                $permission = $request->get('permission');
                if(!empty($permission)){
                    foreach ($permission as $item){
                        PermissionRole::create([
                            'role_id'=>$role->id,
                            'permission_id'=>$item
                        ]);
                    }
                }
            });
            set_message(__('s.role_saved'));
        }
        return response()->json(['success'=>true,'message'=>__('s.role_saved')]);
    }
    //update
    public function edit($id = 0,Request $request){
        can('role.edit',true);
        $role = Role::findOrFail($id);
        return view('role.create',compact('role'));
    }
    public function update($id,Request $request){
        can('role.edit',true);
        $role = Role::find($id);
        $message_result = [];
        $validation_array = [
            'name' => 'required',
        ];
        //check for validation
        $validator = Validator::make($request->all(), $validation_array);
        if ($validator->fails()) {
            $messages = $validator->messages();
            foreach ($messages->all('<p>:message</p>') as $index => $message) {
                array_push($message_result, $message);
            }
            return response()->json(['success' => false, 'message' => $message_result]);
        }
        else{

            DB::transaction(function () use ($request,$role) {
                $all_request = $request->all();
                $role->update($all_request);
                //delete old permissions
                PermissionRole::where('role_id',$role->id)->delete();
                //update permissions
                $permission = $request->get('permission');
                if(!empty($permission)){
                    foreach ($permission as $item){
                        PermissionRole::create([
                            'role_id'=>$role->id,
                            'permission_id'=>$item
                        ]);
                    }
                }
            });
            set_message(__('s.role_saved'));
        }
        return response()->json(['success'=>true,'message'=>__('s.role_saved')]);
    }
    //delete
    public function destroy($id,Request $request){
        can('role.delete',true);
        $role = Role::findOrFail($id);
        //check if role has users
        if(count($role->users) > 0){
            set_message(__('s.role_has_users'),'error');
            return redirect()->back();
        }
        $role->delete();
        set_message(__('s.row_deleted'));
        return redirect()->back();
    }
}
