<?php

namespace App\Models;

use App\User;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Booking extends Model
{
    use SoftDeletes;

    protected $table = "bookings";

    protected $fillable = [
        'booking_date',
        'full_name',
        'mobile',
        'email',
        'notes',
        'payment_type',
        'payment_status',
        'created_by',
        'branch_id',
        'wallet_id',
        'user_id'
    ];
    public function user(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function wallet(){
        return $this->belongsTo(Wallet::class,'wallet_id');
    }
    public function discount_code(){
        return $this->hasOne(UserUsedDiscountCode::class,'booking_id');
    }
    public function card(){
        return $this->hasOne(UserUsedCard::class,'booking_id');
    }
    public function details(){
        return $this->hasMany(BookingDetails::class,'booking_id');
    }
    public function branch(){
        return $this->belongsTo(Branch::class,'branch_id');
    }

}
