<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class BuyProduct extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "buy_products";
    protected $fillable = [
        'payment_type',
        'created_by',
        'deleted_by',
        'commission',
        'tip',
        'worker_id',
        'sales_worker_id',
        'discount'
    ];
    public static function boot()
    {
        parent::boot();

        static::creating(function(BuyProduct $row)
        {
            $row->created_by = Auth::id();
        });

        static::created(function(BuyProduct $row)
        {
            set_log('BuyProduct','insert',$row->id);
        });
        static::updated(function(BuyProduct $row)
        {
            set_log('BuyProduct','update',$row->id);
        });
        static::deleted(function(BuyProduct $row)
        {
            set_log('BuyProduct','delete',$row->id);
        });
    }

    public function details(){
        return $this->hasMany(BuyProductDetail::class,'buy_product_id');
    }
    public function created_by_user(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function sales_employee_user(){
        return $this->belongsTo(Worker::class,'sales_worker_id');
    }
}
