<?php

namespace App\Models;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class MemberShip extends Model
{

    //soft delete
    use SoftDeletes;
    //timestamp
    public $timestamps = true;
    //table
    protected $table = "memberships_cards";
    protected $fillable = [
        'user_id',
        'membership_no',
        'percent',
        'start_at',
        'end_at',
        'status',
    ];
    public static function boot()
    {
        parent::boot();

        static::creating(function(MemberShip $row)
        {
            $row->created_by = Auth::id();
        });

        static::created(function(MemberShip $row)
        {
            set_log('MemberShip','insert',$row->id);
        });
        static::updated(function(MemberShip $row)
        {
            set_log('MemberShip','update',$row->id);
        });
        static::deleted(function(MemberShip $row)
        {
            set_log('MemberShip','delete',$row->id);
        });
    }
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }

    public function created_by_user(){
        return $this->belongsTo(User::class,'created_by');
    }
}
